/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.subscriber;

import java.util.function.Predicate;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.test.subscriber.ConditionalTestSubscriber;
import reactor.test.subscriber.DefaultTestSubscriber;
import reactor.test.subscriber.TestSubscriberBuilder;
import reactor.util.context.Context;

final class DefaultConditionalTestSubscriber<T>
extends DefaultTestSubscriber<T>
implements ConditionalTestSubscriber<T> {
    final Predicate<? super T> tryOnNextPredicate;

    DefaultConditionalTestSubscriber(TestSubscriberBuilder options, Predicate<? super T> tryOnNextPredicate) {
        super(options);
        this.tryOnNextPredicate = tryOnNextPredicate;
    }

    public boolean tryOnNext(T t) {
        int previousState = this.markOnNextStart();
        boolean wasTerminated = DefaultConditionalTestSubscriber.isMarkedTerminated(previousState);
        boolean wasOnNext = DefaultConditionalTestSubscriber.isMarkedOnNext(previousState);
        if (wasTerminated || wasOnNext) {
            this.protocolErrors.add(Signal.next(t));
            return false;
        }
        try {
            if (this.tryOnNextPredicate.test(t)) {
                this.receivedOnNext.add(t);
                if (this.cancelled.get()) {
                    this.receivedPostCancellation.add(t);
                }
                this.checkTerminatedAfterOnNext();
                return true;
            }
            Operators.onDiscard(t, (Context)this.currentContext());
            this.checkTerminatedAfterOnNext();
            return false;
        }
        catch (Throwable predicateError) {
            this.markOnNextDone();
            this.internalCancel();
            this.onError(predicateError);
            return false;
        }
    }
}

