/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.publisher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.test.publisher.TestPublisher;
import reactor.util.annotation.Nullable;

final class ColdTestPublisher<T>
extends TestPublisher<T> {
    private static final ColdTestPublisherSubscription[] EMPTY = new ColdTestPublisherSubscription[0];
    final List<T> values;
    Throwable error;
    volatile boolean wasRequested;
    volatile boolean wasSubscribed;
    volatile ColdTestPublisherSubscription<T>[] subscribers = EMPTY;
    volatile int cancelCount;
    static final AtomicIntegerFieldUpdater<ColdTestPublisher> CANCEL_COUNT = AtomicIntegerFieldUpdater.newUpdater(ColdTestPublisher.class, "cancelCount");

    ColdTestPublisher() {
        this.values = Collections.synchronizedList(new ArrayList());
    }

    public void subscribe(Subscriber<? super T> s) {
        Objects.requireNonNull(s, "s");
        ColdTestPublisherSubscription<T> p = new ColdTestPublisherSubscription<T>(s, this);
        s.onSubscribe(p);
        if (this.add(p)) {
            if (p.cancelled) {
                this.remove(p);
            }
            this.wasSubscribed = true;
            for (T value : this.values) {
                p.onNext(value);
            }
            if (this.error == Exceptions.TERMINATED) {
                p.onComplete();
            } else if (this.error != null) {
                p.onError(this.error);
            }
        } else {
            Throwable e = this.error;
            if (e != null) {
                s.onError(e);
            } else {
                s.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(ColdTestPublisherSubscription<T> s) {
        ColdTestPublisher coldTestPublisher = this;
        synchronized (coldTestPublisher) {
            ColdTestPublisherSubscription<T>[] a = this.subscribers;
            int len = a.length;
            ColdTestPublisherSubscription[] b = new ColdTestPublisherSubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s;
            this.subscribers = b;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ColdTestPublisherSubscription<T> s) {
        ColdTestPublisherSubscription<T>[] a = this.subscribers;
        if (a == EMPTY) {
            return;
        }
        ColdTestPublisher coldTestPublisher = this;
        synchronized (coldTestPublisher) {
            a = this.subscribers;
            if (a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                this.subscribers = EMPTY;
                return;
            }
            ColdTestPublisherSubscription[] b = new ColdTestPublisherSubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
            this.subscribers = b;
        }
    }

    @Override
    public Flux<T> flux() {
        return Flux.from((Publisher)this);
    }

    @Override
    public boolean wasSubscribed() {
        return this.wasSubscribed;
    }

    @Override
    public boolean wasCancelled() {
        return this.cancelCount > 0;
    }

    @Override
    public boolean wasRequested() {
        return this.wasRequested;
    }

    @Override
    public Mono<T> mono() {
        return Mono.from((Publisher)this);
    }

    @Override
    public ColdTestPublisher<T> assertMinRequested(long n) {
        ColdTestPublisherSubscription<T>[] subs = this.subscribers;
        long minRequest = Stream.of(subs).mapToLong(s -> s.requested).min().orElse(0L);
        if (minRequest < n) {
            throw new AssertionError((Object)("Expected minimum request of " + n + "; got " + minRequest));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertSubscribers() {
        ColdTestPublisherSubscription<T>[] s = this.subscribers;
        if (s == EMPTY) {
            throw new AssertionError((Object)"Expected subscribers");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertSubscribers(int n) {
        int sl = this.subscribers.length;
        if (sl != n) {
            throw new AssertionError((Object)("Expected " + n + " subscribers, got " + sl));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertNoSubscribers() {
        int sl = this.subscribers.length;
        if (sl != 0) {
            throw new AssertionError((Object)("Expected no subscribers, got " + sl));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertCancelled() {
        if (this.cancelCount == 0) {
            throw new AssertionError((Object)"Expected at least 1 cancellation");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertCancelled(int n) {
        int cc = this.cancelCount;
        if (cc != n) {
            throw new AssertionError((Object)("Expected " + n + " cancellations, got " + cc));
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertNotCancelled() {
        if (this.cancelCount != 0) {
            throw new AssertionError((Object)"Expected no cancellation");
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> assertRequestOverflow() {
        throw new AssertionError((Object)"Expected some request overflow");
    }

    @Override
    public ColdTestPublisher<T> assertNoRequestOverflow() {
        return this;
    }

    @Override
    public ColdTestPublisher<T> next(@Nullable T t) {
        Objects.requireNonNull(t, "emitted values must be non-null");
        this.values.add(t);
        for (ColdTestPublisherSubscription<T> s : this.subscribers) {
            s.onNext(t);
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> error(Throwable t) {
        ColdTestPublisherSubscription<T>[] subs;
        Objects.requireNonNull(t, "t");
        this.error = t;
        for (ColdTestPublisherSubscription<T> s : subs = this.subscribers) {
            s.onError(t);
        }
        return this;
    }

    @Override
    public ColdTestPublisher<T> complete() {
        ColdTestPublisherSubscription<T>[] subs = this.subscribers;
        this.error = Exceptions.TERMINATED;
        for (ColdTestPublisherSubscription<T> s : subs) {
            s.onComplete();
        }
        return this;
    }

    static final class ColdTestPublisherSubscription<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final ColdTestPublisher<T> parent;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<ColdTestPublisherSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(ColdTestPublisherSubscription.class, "requested");

        ColdTestPublisherSubscription(Subscriber<? super T> actual, ColdTestPublisher<T> parent) {
            this.actual = actual;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
            this.parent = parent;
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                Operators.addCap(REQUESTED, (Object)this, (long)n);
                this.parent.wasRequested = true;
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                CANCEL_COUNT.incrementAndGet(this.parent);
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        void onNext(T value) {
            long r = this.requested;
            if (r != 0L) {
                boolean sent;
                if (this.actualConditional != null) {
                    sent = this.actualConditional.tryOnNext(value);
                } else {
                    sent = true;
                    this.actual.onNext(value);
                }
                if (sent && r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return;
            }
            this.parent.remove(this);
            this.actual.onError((Throwable)new IllegalStateException("Can't deliver value due to lack of requests"));
        }

        void onError(Throwable e) {
            this.parent.remove(this);
            this.actual.onError(e);
        }

        void onComplete() {
            this.parent.remove(this);
            this.actual.onComplete();
        }
    }
}

