/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.passive;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.rx.action.Action;

public class LoggerAction<T>
extends Action<T, T> {
    private final Logger log;

    public LoggerAction(String logger) {
        this.log = logger != null && !logger.isEmpty() ? LoggerFactory.getLogger((String)logger) : LoggerFactory.getLogger(LoggerAction.class);
    }

    @Override
    protected void doNext(T ev) {
        this.log.info("onNext: {}", ev);
        this.broadcastNext(ev);
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        this.log.info("subscribe: {}", (Object)subscriber.getClass().getSimpleName());
        super.subscribe(subscriber);
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        this.log.info("onSubscribe: {}", (Object)subscription);
        super.doOnSubscribe(subscription);
    }

    @Override
    protected void doError(Throwable ev) {
        this.log.error("onError: {}", (Object)this.debug(), (Object)ev);
        super.doError(ev);
    }

    @Override
    public void requestMore(long n) {
        this.log.info("request: {}", (Object)n);
        super.requestMore(n);
    }

    @Override
    public void cancel() {
        if (this.upstreamSubscription != null && this.upstreamSubscription.getPublisher() != null) {
            this.log.info("cancel: {}", (Object)this.upstreamSubscription.getPublisher().getClass().getSimpleName());
        } else {
            this.log.info("cancel");
        }
        super.cancel();
    }

    @Override
    protected void doComplete() {
        if (this.upstreamSubscription != null && this.upstreamSubscription.getPublisher() != null) {
            this.log.info("complete: {}", (Object)this.upstreamSubscription.getPublisher().getClass().getSimpleName());
        } else {
            this.log.info("complete");
        }
        super.doComplete();
    }

    @Override
    public String toString() {
        return super.toString() + "{logger=" + this.log.getName() + "}";
    }
}

