/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.reactivestreams.SerializedSubscriber;
import reactor.fn.Consumer;
import reactor.rx.action.Action;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.subscription.ReactiveSubscription;

public class FanInSubscription<O, E, X, SUBSCRIBER extends FanInAction.InnerSubscriber<O, E, X>>
extends ReactiveSubscription<E>
implements Subscriber<E> {
    volatile int runningComposables = 0;
    static final AtomicIntegerFieldUpdater<FanInSubscription> RUNNING_COMPOSABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FanInSubscription.class, "runningComposables");
    protected final FastList subscriptions = new FastList();
    protected final SerializedSubscriber<E> serializer = SerializedSubscriber.create((Subscriber)this);
    protected volatile boolean terminated = false;
    protected int leftIndex = Integer.MAX_VALUE;

    public FanInSubscription(Subscriber<? super E> subscriber) {
        super(null, subscriber);
        this.serializer.onSubscribe((Subscription)this);
    }

    @Override
    protected void onRequest(long elements) {
        this.parallelRequest(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parallelRequest(long elements) {
        try {
            Action.checkRequest(elements);
            int size = this.runningComposables;
            if (size > 0) {
                int arraySize;
                FanInAction.InnerSubscriber[] subs;
                FanInSubscription fanInSubscription = this;
                synchronized (fanInSubscription) {
                    if (this.subscriptions.size == 0) {
                        return;
                    }
                    subs = this.subscriptions.array;
                    arraySize = this.subscriptions.size;
                }
                for (int i = 0; i < arraySize; ++i) {
                    FanInAction.InnerSubscriber sub = subs[i];
                    if (sub == null) continue;
                    sub.request(elements);
                    if (this.terminated) break;
                }
            }
            if (this.terminated) {
                this.cancel();
            }
        }
        catch (Throwable t) {
            this.subscriber.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<InnerSubscription<O, E, SUBSCRIBER>> consumer) {
        try {
            int size;
            FanInAction.InnerSubscriber[] subs;
            FanInSubscription fanInSubscription = this;
            synchronized (fanInSubscription) {
                if (this.subscriptions.size == 0) {
                    return;
                }
                subs = this.subscriptions.array;
                size = this.subscriptions.size;
            }
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    FanInAction.InnerSubscriber sub = subs[i];
                    if (sub == null) continue;
                    consumer.accept(sub.s);
                }
            }
        }
        catch (Throwable t) {
            this.subscriber.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        int size;
        FanInAction.InnerSubscriber[] subs;
        super.cancel();
        FanInSubscription fanInSubscription = this;
        synchronized (fanInSubscription) {
            if (this.subscriptions.size == 0) {
                return;
            }
            subs = this.subscriptions.array;
            size = this.subscriptions.size;
        }
        FanInAction.InnerSubscriber sub = null;
        for (int i = 0; i < size; ++i) {
            FanInSubscription fanInSubscription2 = this;
            synchronized (fanInSubscription2) {
                if (subs[i] != null) {
                    sub = subs[i];
                    subs[i] = null;
                }
            }
            if (sub == null) continue;
            sub.cancel();
        }
        FanInSubscription fanInSubscription3 = this;
        synchronized (fanInSubscription3) {
            this.subscriptions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addSubscription(FanInAction.InnerSubscriber s) {
        if (this.terminated) {
            return 0;
        }
        FanInSubscription fanInSubscription = this;
        synchronized (fanInSubscription) {
            if (this.leftIndex < this.subscriptions.size && this.subscriptions.array[this.leftIndex] == null) {
                this.subscriptions.array[this.leftIndex] = s;
            } else {
                this.subscriptions.add(s);
                this.leftIndex = this.subscriptions.size - 1;
            }
            return this.leftIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int sequenceId) {
        FanInSubscription fanInSubscription = this;
        synchronized (fanInSubscription) {
            if (sequenceId < this.subscriptions.size) {
                this.subscriptions.array[sequenceId] = null;
                this.leftIndex = this.leftIndex > sequenceId ? sequenceId : this.leftIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InnerSubscription<O, E, SUBSCRIBER> shift(int sequenceId) {
        FanInSubscription fanInSubscription = this;
        synchronized (fanInSubscription) {
            if (sequenceId < this.subscriptions.size) {
                this.subscriptions.array[sequenceId] = null;
                for (int i = 0; i < this.subscriptions.size; ++i) {
                    FanInAction.InnerSubscriber sub = this.subscriptions.array[i];
                    if (sub == null) continue;
                    return sub.s;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InnerSubscription<O, E, SUBSCRIBER> peek() {
        FanInSubscription fanInSubscription = this;
        synchronized (fanInSubscription) {
            for (int i = 0; i < this.subscriptions.size; ++i) {
                if (this.subscriptions.array[i] == null) continue;
                return this.subscriptions.array[i].s;
            }
        }
        return null;
    }

    public void onSubscribe(Subscription s) {
    }

    public void serialNext(E next) {
        this.serializer.onNext(next);
    }

    public void serialError(Throwable t) {
        this.serializer.onError(t);
    }

    public void serialComplete() {
        this.serializer.onComplete();
    }

    @Override
    public String toString() {
        return super.toString() + this.serializer;
    }

    static final class FastList {
        FanInAction.InnerSubscriber[] array;
        int size;

        FastList() {
        }

        public void add(FanInAction.InnerSubscriber o) {
            int s = this.size;
            FanInAction.InnerSubscriber[] a = this.array;
            if (a == null) {
                this.array = a = new FanInAction.InnerSubscriber[16];
            } else if (s == a.length) {
                FanInAction.InnerSubscriber[] array2 = new FanInAction.InnerSubscriber[s + (s >> 2)];
                System.arraycopy(a, 0, array2, 0, s);
                this.array = a = array2;
            }
            a[s] = o;
            this.size = s + 1;
        }

        public void clear() {
            this.array = null;
            this.size = 0;
        }
    }

    public static class InnerSubscription<O, E, SUBSCRIBER extends FanInAction.InnerSubscriber<O, E, ?>>
    implements Subscription {
        final SUBSCRIBER subscriber;
        Subscription wrapped;

        public InnerSubscription(Subscription wrapped, SUBSCRIBER subscriber) {
            this.wrapped = wrapped;
            this.subscriber = subscriber;
        }

        public void request(long n) {
            this.wrapped.request(n);
        }

        public void cancel() {
            this.wrapped.cancel();
        }

        public Subscription getDelegate() {
            return this.wrapped;
        }
    }
}

