/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfiguration;
import reactor.netty.http.client.HttpClientFinalizer;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.WebsocketClientOperations;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.netty.tcp.TcpClient;

final class WebsocketFinalizer
extends HttpClient
implements HttpClient.WebsocketSender {
    final TcpClient cachedConfiguration;

    WebsocketFinalizer(TcpClient parent) {
        this.cachedConfiguration = parent;
    }

    @Override
    public HttpClient.WebsocketSender uri(String uri) {
        return new WebsocketFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.uri(b, uri)));
    }

    @Override
    public HttpClient.WebsocketSender uri(Mono<String> uri) {
        return new WebsocketFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.deferredConf(b, conf -> uri.map(conf::uri))));
    }

    public WebsocketFinalizer send(Function<? super HttpClientRequest, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        return new WebsocketFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.body(b, (req, out) -> (Publisher)sender.apply((HttpClientRequest)req))));
    }

    @Override
    public Mono<WebsocketClientOperations> connect() {
        return this.cachedConfiguration.connect();
    }

    @Override
    public ByteBufFlux receive() {
        return HttpClientFinalizer.content(this.cachedConfiguration, HttpClientFinalizer.contentReceiver);
    }

    @Override
    public <V> Flux<V> handle(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<V>> receiver) {
        return this.connect().flatMapMany(c -> Flux.from((Publisher)((Publisher)receiver.apply((WebsocketInbound)c, (WebsocketOutbound)c))).doFinally(s -> HttpClientFinalizer.discard(c)));
    }
}

