/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerOperator;

final class TcpServerSecure
extends TcpServerOperator {
    final SslProvider sslProvider;

    TcpServerSecure(TcpServer server, Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        super(server);
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        SslProvider.Build builder = (SslProvider.Build)SslProvider.builder();
        sslProviderBuilder.accept(builder);
        this.sslProvider = builder.build();
    }

    @Override
    public ServerBootstrap configure() {
        return SslProvider.setBootstrap(this.source.configure(), this.sslProvider);
    }

    @Override
    public SslProvider sslProvider() {
        return this.sslProvider;
    }
}

