/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.publisher.Mono;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.annotation.Nullable;

final class WebsocketClientOperations
extends HttpClientOperations
implements WebsocketInbound,
WebsocketOutbound {
    final WebSocketClientHandshaker handshaker;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<WebsocketClientOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketClientOperations.class, "closeSent");

    WebsocketClientOperations(URI currentURI, String protocols, int maxFramePayloadLength, HttpClientOperations replaced) {
        super(replaced);
        Channel channel = this.channel();
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)currentURI, (WebSocketVersion)WebSocketVersion.V13, (String)(protocols.isEmpty() ? null : protocols), (boolean)true, (HttpHeaders)replaced.requestHeaders().remove((CharSequence)HttpHeaderNames.HOST), (int)maxFramePayloadLength);
        this.handshaker.handshake(channel).addListener(f -> {
            this.markPersistent(false);
            channel.read();
        });
    }

    @Override
    public HttpHeaders headers() {
        return this.responseHeaders();
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.actualSubprotocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.started = true;
            this.channel().pipeline().remove(HttpObjectAggregator.class);
            FullHttpResponse response = (FullHttpResponse)msg;
            this.setNettyResponse((HttpResponse)response);
            if (this.notRedirected((HttpResponse)response)) {
                try {
                    this.handshaker.finishHandshake(this.channel(), response);
                    this.listener().onStateChange(this, RESPONSE_RECEIVED);
                }
                catch (WebSocketHandshakeException wshe) {
                    this.onInboundError(wshe);
                }
                finally {
                    response.content().release();
                }
            }
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            this.channel().writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            ctx.read();
            return;
        }
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            this.onInboundComplete();
            CloseWebSocketFrame close = (CloseWebSocketFrame)msg;
            this.sendCloseNow(new CloseWebSocketFrame(true, close.rsv(), close.content()));
        } else if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Cancelling Websocket inbound. Closing Websocket"));
        }
        this.sendCloseNow(null);
    }

    @Override
    protected void onInboundClose() {
        this.terminate();
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendCloseNow(new CloseWebSocketFrame(1002, "Client internal error"));
        }
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @javax.annotation.Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @javax.annotation.Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    return this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                return this.channel().newSucceededFuture();
            });
        }
        return Mono.empty();
    }

    void sendCloseNow(@Nullable CloseWebSocketFrame frame) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush((Object)frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            ChannelFuture f = this.channel().writeAndFlush((Object)(frame == null ? new CloseWebSocketFrame() : frame));
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

