/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.NettyPipeline;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpInfos;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent = 0;
    static final int READY = 0;
    static final int HEADERS_SENT = 1;
    static final int BODY_SENT = 2;
    static final AtomicIntegerFieldUpdater<HttpOperations> HTTP_STATE = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ByteBuf bb = ((ByteBufHolder)msg).content();
                ctx.fireChannelRead((Object)bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });

    protected HttpOperations(HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(replaced);
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Connection connection, ConnectionObserver listener) {
        super(connection, listener);
        connection.channel().config().setAutoRead(false);
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent != 0;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    @Override
    public Mono<Void> then() {
        if (this.hasSentHeaders()) {
            return Mono.empty();
        }
        return FutureMono.deferFuture(() -> {
            if (this.markSentHeaders()) {
                HttpMessage msg;
                if (HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                    this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                    msg = HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)0) == 0 ? this.newFullEmptyBodyMessage() : this.outboundHttpMessage();
                } else {
                    msg = this.outboundHttpMessage();
                }
                this.preSendHeadersAndStatus();
                return this.channel().writeAndFlush((Object)msg);
            }
            return this.channel().newSucceededFuture();
        });
    }

    protected abstract void preSendHeadersAndStatus();

    protected abstract HttpMessage newFullEmptyBodyMessage();

    @Override
    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.outboundHttpMessage(), (boolean)true);
        }
        return super.sendFile(file, position, count);
    }

    @Override
    public String toString() {
        if (this.isWebsocket()) {
            return "ws{uri=" + this.uri() + ", connection=" + this.connection() + "}";
        }
        return this.method().name() + "{uri=" + this.uri() + ", connection=" + this.connection() + "}";
    }

    @Override
    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor(this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(Connection c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, (ChannelHandler)HTTP_EXTRACTOR);
            if (c.isPersistent()) {
                c.onTerminate().subscribe(null, null, () -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markSentHeaders() {
        return HTTP_STATE.compareAndSet(this, 0, 1);
    }

    protected final boolean markSentBody() {
        return HTTP_STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean markSentHeaderAndBody() {
        return HTTP_STATE.compareAndSet(this, 0, 2);
    }

    protected abstract HttpMessage outboundHttpMessage();
}

