/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import reactor.netty.ReactorNetty;
import reactor.netty.quic.QuicStreamOperations;
import reactor.util.Logger;
import reactor.util.Loggers;

final class QuicOutboundStreamTrafficHandler
extends ChannelInboundHandlerAdapter {
    static final Logger log = Loggers.getLogger(QuicOutboundStreamTrafficHandler.class);

    QuicOutboundStreamTrafficHandler() {
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"Remote peer sent WRITE_FIN."));
            }
            ctx.channel().config().setAutoRead(true);
            QuicStreamOperations.callTerminate(ctx.channel());
        }
        ctx.fireUserEventTriggered(evt);
    }
}

