/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.quic.QuicChannel;
import io.netty.handler.codec.quic.QuicChannelBootstrap;
import io.netty.util.AttributeKey;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.ChannelBindException;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.quic.QuicClient;
import reactor.netty.quic.QuicClientConfig;
import reactor.netty.quic.QuicConnection;
import reactor.netty.quic.QuicTransport;
import reactor.netty.quic.QuicTransportConfig;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.TransportConfig;
import reactor.netty.transport.TransportConnector;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class QuicClientConnect
extends QuicClient {
    static final QuicClientConnect INSTANCE;
    final QuicClientConfig config;
    static final int DEFAULT_PORT;

    QuicClientConnect() {
        this.config = new QuicClientConfig(Collections.emptyMap(), Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, 0), () -> new InetSocketAddress(NetUtil.LOCALHOST, DEFAULT_PORT));
    }

    QuicClientConnect(QuicClientConfig config) {
        this.config = config;
    }

    public QuicClientConfig configuration() {
        return this.config;
    }

    @Override
    public Mono<? extends QuicConnection> connect() {
        QuicClientConfig config = this.configuration();
        QuicClientConnect.validate(config);
        Mono mono = Mono.create(sink -> {
            InetSocketAddress localInet;
            Supplier bindAddress = Objects.requireNonNull(config.bindAddress());
            SocketAddress local = Objects.requireNonNull((SocketAddress)bindAddress.get(), "Bind Address supplier returned null");
            if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                local = AddressUtils.createResolved((String)localInet.getHostName(), (int)localInet.getPort());
            }
            DisposableConnect disposableConnect = new DisposableConnect(config, local, (MonoSink<QuicConnection>)sink);
            TransportConnector.bind((TransportConfig)config, config.parentChannelInitializer(), (SocketAddress)local, (boolean)false).subscribe((CoreSubscriber)disposableConnect);
        });
        Consumer<? super QuicClientConfig> doOnConnect = config.doOnConnect;
        if (doOnConnect != null) {
            mono = mono.doOnSubscribe(s -> doOnConnect.accept(config));
        }
        return mono;
    }

    protected QuicClient duplicate() {
        return new QuicClientConnect(new QuicClientConfig(this.config));
    }

    static void validate(QuicClientConfig config) {
        Objects.requireNonNull(config.bindAddress(), "bindAddress");
        Objects.requireNonNull(config.remoteAddress, "remoteAddress");
        Objects.requireNonNull(config.sslEngineProvider, "sslEngineProvider");
    }

    static {
        int port;
        INSTANCE = new QuicClientConnect();
        String portStr = null;
        try {
            portStr = System.getenv("QUIC_PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [QUIC_PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }

    static final class QuicChannelObserver
    implements ConnectionObserver {
        final ConnectionObserver childObs;
        final MonoSink<QuicConnection> sink;

        QuicChannelObserver(ConnectionObserver childObs, MonoSink<QuicConnection> sink) {
            this.childObs = childObs;
            this.sink = sink;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success((Object)((QuicConnection)Connection.from((Channel)connection.channel())));
            }
            this.childObs.onStateChange(connection, newState);
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.sink.error(error);
            this.childObs.onUncaughtException(connection, error);
        }
    }

    static final class DisposableConnect
    implements CoreSubscriber<Channel>,
    Disposable {
        final Map<AttributeKey<?>, ?> attributes;
        final SocketAddress bindAddress;
        final Context currentContext;
        final @Nullable ChannelHandler loggingHandler;
        final Map<ChannelOption<?>, ?> options;
        final ChannelInitializer<Channel> quicChannelInitializer;
        final Supplier<? extends SocketAddress> remoteAddress;
        final MonoSink<QuicConnection> sink;
        final Map<AttributeKey<?>, ?> streamAttrs;
        final ConnectionObserver streamObserver;
        final Map<ChannelOption<?>, ?> streamOptions;
        Subscription subscription;

        DisposableConnect(QuicClientConfig config, SocketAddress bindAddress, MonoSink<QuicConnection> sink) {
            this.attributes = config.attributes();
            this.bindAddress = bindAddress;
            this.currentContext = Context.of((ContextView)sink.contextView());
            this.loggingHandler = config.loggingHandler();
            this.options = config.options();
            QuicChannelObserver observer = new QuicChannelObserver(config.defaultConnectionObserver().then(config.connectionObserver()), sink);
            this.quicChannelInitializer = config.channelInitializer(observer, null, false);
            this.remoteAddress = config.remoteAddress;
            this.sink = sink;
            this.streamAttrs = config.streamAttrs;
            this.streamObserver = config.streamObserver.then((ConnectionObserver)new QuicTransportConfig.QuicStreamChannelObserver(config.streamHandler));
            this.streamOptions = config.streamOptions;
        }

        public Context currentContext() {
            return this.currentContext;
        }

        public void dispose() {
            this.subscription.cancel();
        }

        public void onComplete() {
        }

        public void onError(Throwable t) {
            if (t instanceof BindException || t instanceof IOException && t.getMessage() != null && t.getMessage().contains("bind(..)")) {
                this.sink.error((Throwable)ChannelBindException.fail((SocketAddress)this.bindAddress, null));
            } else {
                this.sink.error(t);
            }
        }

        public void onNext(Channel channel) {
            if (QuicTransport.log.isDebugEnabled()) {
                QuicTransport.log.debug(ReactorNetty.format((Channel)channel, (String)"Bound new channel"));
            }
            SocketAddress remote = Objects.requireNonNull(this.remoteAddress.get(), "Remote Address supplier returned null");
            QuicChannelBootstrap bootstrap = QuicChannel.newBootstrap((Channel)channel).remoteAddress(remote).handler(this.quicChannelInitializer).streamHandler(QuicTransportConfig.streamChannelInitializer(this.loggingHandler, this.streamObserver, true));
            DisposableConnect.attributes(bootstrap, this.attributes);
            DisposableConnect.channelOptions(bootstrap, this.options);
            DisposableConnect.streamAttributes(bootstrap, this.streamAttrs);
            DisposableConnect.streamChannelOptions(bootstrap, this.streamOptions);
            bootstrap.connect().addListener(f -> {
                if (!f.isSuccess()) {
                    if (f.cause() != null) {
                        this.sink.error(f.cause());
                    } else {
                        this.sink.error((Throwable)new IOException("Cannot connect to [" + remote + "]"));
                    }
                }
            });
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                this.subscription = s;
                this.sink.onCancel((Disposable)this);
                s.request(Long.MAX_VALUE);
            }
        }

        static void attributes(QuicChannelBootstrap bootstrap, Map<AttributeKey<?>, ?> attrs) {
            for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
                bootstrap.attr(e.getKey(), e.getValue());
            }
        }

        static void channelOptions(QuicChannelBootstrap bootstrap, Map<ChannelOption<?>, ?> options) {
            for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
                bootstrap.option(e.getKey(), e.getValue());
            }
        }

        static void streamAttributes(QuicChannelBootstrap bootstrap, Map<AttributeKey<?>, ?> attrs) {
            for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
                bootstrap.streamAttr(e.getKey(), e.getValue());
            }
        }

        static void streamChannelOptions(QuicChannelBootstrap bootstrap, Map<ChannelOption<?>, ?> options) {
            for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
                bootstrap.streamOption(e.getKey(), e.getValue());
            }
        }
    }
}

