/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.context.ContextView;

final class ContextAwareHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final ContextAwareHttpServerMetricsRecorder recorder;

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
    }

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
    }

    @Override
    protected ContextAwareHttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void contextView(HttpServerOperations ops) {
        this.contextView = ops.currentContext();
    }

    @Override
    protected void recordException() {
        this.recorder().incrementErrorsCount(Objects.requireNonNull(this.contextView), Objects.requireNonNull(this.remoteSocketAddress), Objects.requireNonNull(this.path));
    }

    @Override
    protected void recordRead() {
        this.recorder().recordDataReceivedTime(Objects.requireNonNull(this.contextView), Objects.requireNonNull(this.path), Objects.requireNonNull(this.method), Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(this.contextView, Objects.requireNonNull(this.remoteSocketAddress), this.path, this.dataReceived);
    }

    @Override
    protected void recordWrite(Channel channel) {
        this.recordWrite(Objects.requireNonNull(this.contextView), this.dataReceivedTime, this.dataSent, this.dataSentTime, Objects.requireNonNull(this.method), Objects.requireNonNull(this.path), Objects.requireNonNull(this.remoteSocketAddress), Objects.requireNonNull(this.status));
    }

    @Override
    protected void recordWrite(Channel channel, AbstractHttpServerMetricsHandler.MetricsArgProvider metricsArgProvider) {
        this.recordWrite(Objects.requireNonNull(metricsArgProvider.contextView), metricsArgProvider.dataReceivedTime, metricsArgProvider.dataSent, metricsArgProvider.dataSentTime, Objects.requireNonNull(metricsArgProvider.method), Objects.requireNonNull(metricsArgProvider.path), Objects.requireNonNull(metricsArgProvider.remoteSocketAddress), Objects.requireNonNull(metricsArgProvider.status));
    }

    void recordWrite(ContextView contextView, long dataReceivedTime, long dataSent, long dataSentTime, String method, String path, SocketAddress remoteSocketAddress, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - dataSentTime);
        this.recorder().recordDataSentTime(contextView, path, method, status, dataSentTimeDuration);
        if (dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(contextView, path, method, status, Duration.ofNanos(System.nanoTime() - dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(contextView, path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(contextView, remoteSocketAddress, path, dataSent);
    }
}

