/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import reactor.netty.http.logging.AbstractHttpMessageArgProvider;
import reactor.netty.http.logging.HttpMessageType;
import reactor.util.annotation.Nullable;

final class HttpResponseArgProvider
extends AbstractHttpMessageArgProvider {
    final HttpHeaders httpHeaders;
    final String protocol;
    final String status;

    HttpResponseArgProvider(HttpResponse httpResponse, @Nullable HttpVersion actualVersion) {
        super(httpResponse.decoderResult());
        this.httpHeaders = httpResponse.headers();
        this.protocol = actualVersion != null ? actualVersion.text() : httpResponse.protocolVersion().text();
        this.status = httpResponse.status().toString();
    }

    @Override
    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    @Override
    public HttpMessageType httpMessageType() {
        return HttpMessageType.RESPONSE;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String status() {
        return this.status;
    }
}

