/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import reactor.netty.http.logging.AbstractHttpMessageArgProvider;
import reactor.netty.http.logging.HttpMessageType;
import reactor.util.annotation.Nullable;

final class HttpRequestArgProvider
extends AbstractHttpMessageArgProvider {
    final HttpHeaders httpHeaders;
    final String method;
    final String protocol;
    final String uri;

    HttpRequestArgProvider(HttpRequest httpRequest, @Nullable HttpVersion actualVersion) {
        super(httpRequest.decoderResult());
        this.httpHeaders = httpRequest.headers();
        this.method = httpRequest.method().name();
        this.protocol = actualVersion != null ? actualVersion.text() : httpRequest.protocolVersion().text();
        this.uri = httpRequest.uri();
    }

    @Override
    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    @Override
    public HttpMessageType httpMessageType() {
        return HttpMessageType.REQUEST;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String uri() {
        return this.uri;
    }
}

