/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import reactor.util.annotation.Nullable;

public final class ConnectionInfo {
    static final int DEFAULT_HTTP_PORT = 80;
    static final int DEFAULT_HTTPS_PORT = 443;
    static final String DEFAULT_HOST_NAME = "localhost";
    final InetSocketAddress hostAddress;
    final InetSocketAddress remoteAddress;
    final String scheme;
    final String hostName;
    final int hostPort;

    static ConnectionInfo from(Channel channel, HttpRequest request, boolean secured, SocketAddress remoteAddress, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler) {
        String hostName = DEFAULT_HOST_NAME;
        int hostPort = secured ? 443 : 80;
        String scheme = secured ? "https" : "http";
        String header = request.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (header != null) {
            int portIndex;
            hostName = header;
            int n = portIndex = header.charAt(0) == '[' ? header.indexOf(58, header.indexOf(93)) : header.indexOf(58);
            if (portIndex != -1) {
                hostName = header.substring(0, portIndex);
                hostPort = Integer.parseInt(header.substring(portIndex + 1));
            }
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            return new ConnectionInfo(hostName, hostPort, scheme);
        }
        ConnectionInfo connectionInfo = new ConnectionInfo(((SocketChannel)channel).localAddress(), hostName, hostPort, (InetSocketAddress)remoteAddress, scheme);
        if (forwardedHeaderHandler != null) {
            return forwardedHeaderHandler.apply(connectionInfo, request);
        }
        return connectionInfo;
    }

    ConnectionInfo(String hostName, int hostPort, String scheme) {
        this(null, hostName, hostPort, null, scheme);
    }

    ConnectionInfo(@Nullable InetSocketAddress hostAddress, String hostName, int hostPort, @Nullable InetSocketAddress remoteAddress, String scheme) {
        this.hostAddress = hostAddress;
        this.hostName = hostName;
        this.hostPort = hostPort;
        this.remoteAddress = remoteAddress;
        this.scheme = scheme;
    }

    @Nullable
    public InetSocketAddress getHostAddress() {
        return this.hostAddress;
    }

    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getScheme() {
        return this.scheme;
    }

    public ConnectionInfo withHostAddress(InetSocketAddress hostAddress) {
        Objects.requireNonNull(hostAddress, "hostAddress");
        return new ConnectionInfo(hostAddress, hostAddress.getHostString(), hostAddress.getPort(), this.remoteAddress, this.scheme);
    }

    public ConnectionInfo withRemoteAddress(InetSocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        return new ConnectionInfo(this.hostAddress, this.hostName, this.hostPort, remoteAddress, this.scheme);
    }

    public ConnectionInfo withScheme(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        return new ConnectionInfo(this.hostAddress, this.hostName, this.hostPort, this.remoteAddress, scheme);
    }

    String getHostName() {
        return this.hostName;
    }

    int getHostPort() {
        return this.hostPort;
    }
}

