/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.http.ContextAwareHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ContextAwareHttpClientMetricsRecorder
extends ContextAwareHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    public abstract void recordDataReceivedTime(ContextView var1, SocketAddress var2, String var3, String var4, String var5, Duration var6);

    public void recordDataReceivedTime(ContextView contextView, SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        this.recordDataReceivedTime(contextView, remoteAddress, uri, method, status, time);
    }

    public abstract void recordDataSentTime(ContextView var1, SocketAddress var2, String var3, String var4, Duration var5);

    public void recordDataSentTime(ContextView contextView, SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, Duration time) {
        this.recordDataSentTime(contextView, remoteAddress, uri, method, time);
    }

    public abstract void recordResponseTime(ContextView var1, SocketAddress var2, String var3, String var4, String var5, Duration var6);

    public void recordResponseTime(ContextView contextView, SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        this.recordResponseTime(contextView, remoteAddress, uri, method, status, time);
    }

    public void incrementErrorsCount(ContextView contextView, SocketAddress remoteAddress, SocketAddress proxyAddress, String uri) {
        this.incrementErrorsCount(contextView, remoteAddress, uri);
    }

    public void recordDataReceived(ContextView contextView, SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        this.recordDataReceived(contextView, remoteAddress, uri, bytes);
    }

    public void recordDataSent(ContextView contextView, SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        this.recordDataSent(contextView, remoteAddress, uri, bytes);
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        this.recordDataReceivedTime((ContextView)Context.empty(), remoteAddress, uri, method, status, time);
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        this.recordDataReceivedTime((ContextView)Context.empty(), remoteAddress, proxyAddress, uri, method, status, time);
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method, Duration time) {
        this.recordDataSentTime((ContextView)Context.empty(), remoteAddress, uri, method, time);
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, Duration time) {
        this.recordDataSentTime((ContextView)Context.empty(), remoteAddress, proxyAddress, uri, method, time);
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        this.recordResponseTime((ContextView)Context.empty(), remoteAddress, uri, method, status, time);
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        this.recordResponseTime((ContextView)Context.empty(), remoteAddress, proxyAddress, uri, method, status, time);
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        this.recordDataReceived((ContextView)Context.empty(), remoteAddress, proxyAddress, uri, bytes);
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        this.recordDataSent((ContextView)Context.empty(), remoteAddress, proxyAddress, uri, bytes);
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri) {
        this.incrementErrorsCount((ContextView)Context.empty(), remoteAddress, proxyAddress, uri);
    }
}

