/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import reactor.kafka.receiver.ReceiverOptions;

public class MicrometerConsumerListener
implements ReceiverOptions.ConsumerListener {
    private final MeterRegistry meterRegistry;
    private final List<Tag> tags = new ArrayList<Tag>();
    private final Map<String, KafkaClientMetrics> metrics = new HashMap<String, KafkaClientMetrics>();

    public MicrometerConsumerListener(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public MicrometerConsumerListener(MeterRegistry meterRegistry, List<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags.addAll(tags);
    }

    @Override
    public synchronized void consumerAdded(String id, Consumer<?, ?> consumer) {
        if (!this.metrics.containsKey(id)) {
            ArrayList<Tag> consumerTags = new ArrayList<Tag>(this.tags);
            consumerTags.add((Tag)new ImmutableTag("reactor-kafka.id", id));
            this.metrics.put(id, new KafkaClientMetrics(consumer, consumerTags));
            this.metrics.get(id).bindTo(this.meterRegistry);
        }
    }

    @Override
    public synchronized void consumerRemoved(String id, Consumer<?, ?> consumer) {
        KafkaClientMetrics removed = this.metrics.remove(id);
        if (removed != null) {
            removed.close();
        }
    }
}

