/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverRecord;
import reactor.kafka.receiver.internals.ConsumerFactory;
import reactor.kafka.receiver.internals.DefaultKafkaReceiver;
import reactor.kafka.sender.TransactionManager;

public interface KafkaReceiver<K, V> {
    public static <K, V> KafkaReceiver<K, V> create(ReceiverOptions<K, V> options) {
        return new DefaultKafkaReceiver<K, V>(ConsumerFactory.INSTANCE, options);
    }

    public static <K, V> KafkaReceiver<K, V> create(ConsumerFactory factory, ReceiverOptions<K, V> options) {
        return new DefaultKafkaReceiver<K, V>(factory, options);
    }

    public Flux<ReceiverRecord<K, V>> receive(Integer var1);

    default public Flux<ReceiverRecord<K, V>> receive() {
        return this.receive(null);
    }

    public Flux<Flux<ConsumerRecord<K, V>>> receiveAutoAck(Integer var1);

    default public Flux<Flux<ConsumerRecord<K, V>>> receiveAutoAck() {
        return this.receiveAutoAck(null);
    }

    public Flux<ConsumerRecord<K, V>> receiveAtmostOnce(Integer var1);

    default public Flux<ConsumerRecord<K, V>> receiveAtmostOnce() {
        return this.receiveAtmostOnce(null);
    }

    default public Flux<Flux<ConsumerRecord<K, V>>> receiveExactlyOnce(TransactionManager transactionManager) {
        return this.receiveExactlyOnce(transactionManager, null);
    }

    public Flux<Flux<ConsumerRecord<K, V>>> receiveExactlyOnce(TransactionManager var1, Integer var2);

    public <T> Mono<T> doOnConsumer(Function<Consumer<K, V>, ? extends T> var1);
}

