/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.options.ServerOptions;
import reactor.ipc.netty.tcp.TcpResources;
import reactor.util.Logger;
import reactor.util.Loggers;

public class TcpServer
implements NettyConnector<NettyInbound, NettyOutbound> {
    final ServerOptions options;
    static final LoggingHandler loggingHandler = new LoggingHandler(TcpServer.class);
    static final Logger log = Loggers.getLogger(TcpServer.class);

    public static TcpServer create() {
        return TcpServer.create(NetUtil.LOCALHOST.getHostAddress());
    }

    public static TcpServer create(Consumer<? super ServerOptions.Builder<?>> options) {
        return TcpServer.builder().options(options).build();
    }

    public static TcpServer create(int port) {
        return TcpServer.create("0.0.0.0", port);
    }

    public static TcpServer create(String bindAddress) {
        return TcpServer.create(bindAddress, 0);
    }

    public static TcpServer create(String bindAddress, int port) {
        return TcpServer.builder().bindAddress(bindAddress).port(port).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected TcpServer(Builder builder) {
        ServerOptions.Builder serverOptionsBuilder = ServerOptions.builder();
        if (Objects.isNull(builder.options)) {
            ((ServerOptions.Builder)serverOptionsBuilder.host(builder.bindAddress)).port(builder.port);
        } else {
            builder.options.accept(serverOptionsBuilder);
        }
        if (!serverOptionsBuilder.isLoopAvailable()) {
            serverOptionsBuilder.loopResources(TcpResources.get());
        }
        this.options = serverOptionsBuilder.build();
    }

    protected TcpServer(ServerOptions options) {
        this.options = Objects.requireNonNull(options, "options");
    }

    @Override
    public final Mono<? extends NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return Mono.create((T sink) -> {
            ServerBootstrap b = this.options.get();
            SocketAddress local = this.options.getAddress();
            b.localAddress(local);
            ContextHandler<Channel> contextHandler = this.doHandler(handler, (MonoSink<NettyContext>)sink);
            b.childHandler(contextHandler);
            if (log.isDebugEnabled()) {
                b.handler((ChannelHandler)this.loggingHandler());
            }
            contextHandler.setFuture((Future<?>)b.bind());
        });
    }

    public ServerOptions options() {
        return this.options.duplicate();
    }

    public String toString() {
        return "TcpServer: " + this.options.asSimpleString();
    }

    protected LoggingHandler loggingHandler() {
        return loggingHandler;
    }

    protected ContextHandler<Channel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink) {
        return ContextHandler.newServerContext(sink, this.options, this.loggingHandler(), (ch, c, msg) -> ChannelOperations.bind(ch, handler, c));
    }

    public static final class Builder {
        private String bindAddress = NetUtil.LOCALHOST.getHostAddress();
        private int port = 80;
        private Consumer<? super ServerOptions.Builder<?>> options;

        private Builder() {
        }

        public final Builder bindAddress(String bindAddress) {
            this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
            return this;
        }

        public final Builder port(int port) {
            this.port = Objects.requireNonNull(Integer.valueOf(port), "port");
            return this;
        }

        public final Builder options(Consumer<? super ServerOptions.Builder<?>> options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        public TcpServer build() {
            return new TcpServer(this);
        }
    }
}

