/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.tcp.BlockingNettyContext;

public interface NettyConnector<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound> {
    public Mono<? extends NettyContext> newHandler(BiFunction<? super INBOUND, ? super OUTBOUND, ? extends Publisher<Void>> var1);

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> BlockingNettyContext start(T handler) {
        return new BlockingNettyContext(this.newHandler(handler), this.getClass().getSimpleName());
    }

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> void startAndAwait(T handler) {
        this.startAndAwait(handler, null);
    }

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> void startAndAwait(T handler, @Nullable Consumer<BlockingNettyContext> onStart) {
        BlockingNettyContext facade = new BlockingNettyContext(this.newHandler(handler), this.getClass().getSimpleName());
        facade.installShutdownHook();
        if (onStart != null) {
            onStart.accept(facade);
        }
        facade.getContext().onClose().block();
    }
}

