/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.retry.Backoff;
import reactor.retry.BackoffDelay;
import reactor.retry.Context;
import reactor.retry.Jitter;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class AbstractRetry<T, S>
implements Function<Flux<S>, Publisher<Long>> {
    static final Logger log = Loggers.getLogger(AbstractRetry.class);
    static final BackoffDelay RETRY_EXHAUSTED = new BackoffDelay(Duration.ofSeconds(-1L)){

        @Override
        public String toString() {
            return "{EXHAUSTED}";
        }
    };
    final int maxIterations;
    final Duration timeout;
    final Backoff backoff;
    final Jitter jitter;
    final Scheduler backoffScheduler;
    final T applicationContext;

    AbstractRetry(int maxIterations, Duration timeout, Backoff backoff, Jitter jitter, Scheduler backoffScheduler, T applicationContext) {
        this.maxIterations = maxIterations;
        this.timeout = timeout;
        this.backoff = backoff;
        this.jitter = jitter;
        this.backoffScheduler = backoffScheduler;
        this.applicationContext = applicationContext;
    }

    Instant calculateTimeout() {
        return this.timeout != null ? Instant.now().plus(this.timeout) : Instant.MAX;
    }

    BackoffDelay calculateBackoff(Context<T> retryContext, Instant timeoutInstant) {
        BackoffDelay nextBackoff = (BackoffDelay)this.backoff.apply(retryContext);
        Duration minBackoff = nextBackoff.min;
        Duration maxBackoff = nextBackoff.max;
        Duration backoff = nextBackoff.delay;
        if (maxBackoff != null) {
            Duration duration = backoff = backoff.compareTo(maxBackoff) < 0 ? backoff : maxBackoff;
        }
        if (minBackoff != null) {
            backoff = backoff.compareTo(minBackoff) > 0 ? backoff : minBackoff;
        }
        BackoffDelay sanitizedBackoff = new BackoffDelay(minBackoff, maxBackoff, backoff);
        Duration jitteredBackoff = (Duration)this.jitter.apply(sanitizedBackoff);
        if (retryContext.iteration() > (long)this.maxIterations || Instant.now().plus(jitteredBackoff).isAfter(timeoutInstant)) {
            return RETRY_EXHAUSTED;
        }
        return new BackoffDelay(minBackoff, maxBackoff, jitteredBackoff);
    }

    Publisher<Long> retryMono(Duration delay) {
        if (delay == Duration.ZERO) {
            return Mono.just((Object)0L);
        }
        if (this.backoffScheduler == null) {
            return Mono.delay((Duration)delay);
        }
        return Mono.delay((Duration)delay, (Scheduler)this.backoffScheduler);
    }
}

