/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.notifications.notifier;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.notifications.EndOfDataNotification;
import io.pravega.client.stream.notifications.Listener;
import io.pravega.client.stream.notifications.NotificationSystem;
import io.pravega.client.stream.notifications.notifier.AbstractPollingNotifier;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndOfDataNotifier
extends AbstractPollingNotifier<EndOfDataNotification> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndOfDataNotifier.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final int UPDATE_INTERVAL_SECONDS = Integer.parseInt(System.getProperty("pravega.client.endOfDataNotification.poll.interval.seconds", String.valueOf(120)));

    public EndOfDataNotifier(NotificationSystem notifySystem, StateSynchronizer<ReaderGroupState> synchronizer, ScheduledExecutorService executor) {
        super(notifySystem, executor, synchronizer);
    }

    @VisibleForTesting
    public void pollNow() {
        this.checkAndTriggerEndOfStreamNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(Listener<EndOfDataNotification> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.notifySystem.addListeners(this.getType(), listener, this.executor);
            this.startPolling(this::checkAndTriggerEndOfStreamNotification, UPDATE_INTERVAL_SECONDS);
        }
    }

    @Override
    public String getType() {
        return EndOfDataNotification.class.getSimpleName();
    }

    private void checkAndTriggerEndOfStreamNotification() {
        this.synchronizer.fetchUpdates();
        ReaderGroupState state = (ReaderGroupState)this.synchronizer.getState();
        if (state.isEndOfData()) {
            this.notifySystem.notify(new EndOfDataNotification());
        }
    }
}

