/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.Unpooled;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.RawClient;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.ConditionalOutputStream;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.common.Exceptions;
import io.pravega.common.util.Retry;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.WireCommands;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConditionalOutputStreamImpl
implements ConditionalOutputStream {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConditionalOutputStreamImpl.class);
    private final UUID writerId;
    private final Segment segmentId;
    private final Controller controller;
    private final ConnectionPool connectionPool;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private RawClient client = null;
    private final DelegationTokenProvider tokenProvider;
    private final Supplier<Long> requestIdGenerator = new AtomicLong()::incrementAndGet;
    private final Retry.RetryWithBackoff retrySchedule;

    @Override
    public String getScopedSegmentName() {
        return this.segmentId.getScopedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(ByteBuffer data, long expectedOffset) throws SegmentSealedException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Object object = this.lock;
        synchronized (object) {
            long appendSequence = this.requestIdGenerator.get();
            return (Boolean)this.retrySchedule.retryWhen(e -> {
                Throwable cause = Exceptions.unwrap((Throwable)e);
                boolean hasTokenExpired = cause instanceof TokenExpiredException;
                if (hasTokenExpired) {
                    this.tokenProvider.signalTokenExpired();
                }
                return cause instanceof Exception && (hasTokenExpired || cause instanceof ConnectionFailedException);
            }).run(() -> {
                long requestId;
                if (this.client == null || this.client.isClosed()) {
                    this.client = new RawClient(this.controller, this.connectionPool, this.segmentId);
                    requestId = this.client.getFlow().getNextSequenceNumber();
                    log.debug("Setting up appends on segment {} for ConditionalOutputStream.", (Object)this.segmentId);
                    CompletionStage reply = this.tokenProvider.retrieveToken().thenCompose(token -> {
                        WireCommands.SetupAppend setup = new WireCommands.SetupAppend(requestId, this.writerId, this.segmentId.getScopedName(), token);
                        return this.client.sendRequest(requestId, setup);
                    });
                    WireCommands.AppendSetup appendSetup = this.transformAppendSetup((Reply)((CompletableFuture)reply).join());
                    if (appendSetup.getLastEventNumber() >= appendSequence) {
                        return true;
                    }
                }
                requestId = this.client.getFlow().getNextSequenceNumber();
                WireCommands.ConditionalAppend request = new WireCommands.ConditionalAppend(this.writerId, appendSequence, expectedOffset, new WireCommands.Event(Unpooled.wrappedBuffer((ByteBuffer)data)), requestId);
                CompletableFuture<Reply> reply = this.client.sendRequest(requestId, request);
                return this.transformDataAppended(reply.join());
            });
        }
    }

    @Override
    public void close() {
        log.info("Closing segment metadata connection for {}", (Object)this.segmentId);
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnection("Closed call");
        }
    }

    private WireCommands.AppendSetup transformAppendSetup(Reply reply) {
        if (reply instanceof WireCommands.AppendSetup) {
            return (WireCommands.AppendSetup)reply;
        }
        throw this.handleUnexpectedReply(reply, "AppendSetup");
    }

    private boolean transformDataAppended(Reply reply) {
        if (reply instanceof WireCommands.DataAppended) {
            return true;
        }
        if (reply instanceof WireCommands.ConditionalCheckFailed) {
            return false;
        }
        throw this.handleUnexpectedReply(reply, "DataAppended");
    }

    @VisibleForTesting
    RuntimeException handleUnexpectedReply(Reply reply, String expectation) {
        this.closeConnection(reply.toString());
        if (reply instanceof WireCommands.NoSuchSegment) {
            throw new NoSuchSegmentException(reply.toString());
        }
        if (reply instanceof WireCommands.SegmentIsSealed) {
            throw Exceptions.sneakyThrow((Throwable)new SegmentSealedException(reply.toString()));
        }
        if (reply instanceof WireCommands.WrongHost) {
            throw Exceptions.sneakyThrow((Throwable)new ConnectionFailedException(reply.toString()));
        }
        if (reply instanceof WireCommands.InvalidEventNumber) {
            WireCommands.InvalidEventNumber ien = (WireCommands.InvalidEventNumber)reply;
            throw Exceptions.sneakyThrow((Throwable)new ConnectionFailedException(ien.getWriterId() + "Got stale data from setupAppend on segment " + this.segmentId + " for ConditionalOutputStream. Event number was " + ien.getEventNumber()));
        }
        if (reply instanceof WireCommands.AuthTokenCheckFailed) {
            WireCommands.AuthTokenCheckFailed authTokenCheckFailed = (WireCommands.AuthTokenCheckFailed)reply;
            if (authTokenCheckFailed.isTokenExpired()) {
                this.tokenProvider.signalTokenExpired();
                throw Exceptions.sneakyThrow((Throwable)new TokenExpiredException(authTokenCheckFailed.getServerStackTrace()));
            }
            throw Exceptions.sneakyThrow((Throwable)new AuthenticationException(authTokenCheckFailed.toString()));
        }
        throw Exceptions.sneakyThrow((Throwable)new ConnectionFailedException("Unexpected reply of " + reply + " when expecting an " + expectation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(String message) {
        RawClient c;
        if (this.closed.get()) {
            log.debug("Closing connection as a result of receiving: {} for segment: {}", (Object)message, (Object)this.segmentId);
        } else {
            log.warn("Closing connection as a result of receiving: {} for segment: {}", (Object)message, (Object)this.segmentId);
        }
        Object object = this.lock;
        synchronized (object) {
            c = this.client;
            this.client = null;
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warn("Exception tearing down connection: ", (Throwable)e);
            }
        }
    }

    @ConstructorProperties(value={"writerId", "segmentId", "controller", "connectionPool", "tokenProvider", "retrySchedule"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConditionalOutputStreamImpl(UUID writerId, Segment segmentId, Controller controller, ConnectionPool connectionPool, DelegationTokenProvider tokenProvider, Retry.RetryWithBackoff retrySchedule) {
        this.writerId = writerId;
        this.segmentId = segmentId;
        this.controller = controller;
        this.connectionPool = connectionPool;
        this.tokenProvider = tokenProvider;
        this.retrySchedule = retrySchedule;
    }
}

