/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;

public class CfVolume {
    private static final String MODE_READONLY = "r";
    private final Map<String, String> volumeData;

    public CfVolume(Map<String, String> volumeData) {
        Objects.requireNonNull(volumeData);
        this.volumeData = volumeData;
    }

    public Map<String, String> getMap() {
        return this.volumeData;
    }

    public Path getPath() {
        return Paths.get(this.volumeData.get("container_dir"), new String[0]);
    }

    public Mode getMode() {
        if (MODE_READONLY.equals(this.volumeData.get("mode"))) {
            return Mode.READ_ONLY;
        }
        return Mode.READ_WRITE;
    }

    public static enum Mode {
        READ_ONLY,
        READ_WRITE;

    }
}

