/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.spring.boot;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import io.pivotal.cfenv.spring.boot.ConnectorLibraryDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.StringUtils;

public class CassandraCfEnvProcessor
implements CfEnvProcessor {
    @Override
    public boolean accept(CfService service) {
        boolean serviceIsBound;
        boolean bl = serviceIsBound = service.existsByTagIgnoreCase(new String[]{"cassandra"}) && this.cassandraCredentialsPresent(service.getCredentials().getMap());
        if (serviceIsBound) {
            ConnectorLibraryDetector.assertNoConnectorLibrary();
        }
        return serviceIsBound;
    }

    @Override
    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        properties.put("spring.data.cassandra.username", cfCredentials.getUsername());
        properties.put("spring.data.cassandra.password", cfCredentials.getPassword());
        properties.put("spring.data.cassandra.port", cfCredentials.getMap().get("cqlsh_port"));
        ArrayList contactPoints = (ArrayList)cfCredentials.getMap().get("node_ips");
        properties.put("spring.data.cassandra.contact-points", StringUtils.collectionToCommaDelimitedString((Collection)contactPoints));
    }

    private boolean cassandraCredentialsPresent(Map<String, Object> credentials) {
        return credentials != null && credentials.containsKey("cqlsh_port") && credentials.containsKey("node_ips");
    }

    @Override
    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.data.cassandra").serviceName("Cassandra").build();
    }
}

