/*
 * Pinecone Control Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: v1
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * The distance metric to be used for similarity search. You can use &#39;euclidean&#39;, &#39;cosine&#39;, or &#39;dotproduct&#39;.
 */
@JsonAdapter(IndexMetric.Adapter.class)
public enum IndexMetric {
  
  COSINE("cosine"),
  
  EUCLIDEAN("euclidean"),
  
  DOTPRODUCT("dotproduct");

  private String value;

  IndexMetric(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static IndexMetric fromValue(String value) {
    for (IndexMetric b : IndexMetric.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  public static class Adapter extends TypeAdapter<IndexMetric> {
    @Override
    public void write(final JsonWriter jsonWriter, final IndexMetric enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public IndexMetric read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return IndexMetric.fromValue(value);
    }
  }
}

