/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.node.expression;

import io.pebbletemplates.pebble.error.AttributeNotFoundException;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.extension.core.DefaultFilter;
import io.pebbletemplates.pebble.extension.escaper.EscapeFilter;
import io.pebbletemplates.pebble.extension.escaper.SafeString;
import io.pebbletemplates.pebble.node.ArgumentsNode;
import io.pebbletemplates.pebble.node.expression.BinaryExpression;
import io.pebbletemplates.pebble.node.expression.FilterInvocationExpression;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplateImpl;
import java.util.Map;

public class FilterExpression
extends BinaryExpression<Object> {
    private Filter filter = null;

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        Object input;
        FilterInvocationExpression filterInvocation = (FilterInvocationExpression)this.getRightExpression();
        ArgumentsNode args = filterInvocation.getArgs();
        String filterName = filterInvocation.getFilterName();
        if (this.filter == null) {
            this.filter = context.getExtensionRegistry().getFilter(filterInvocation.getFilterName());
        }
        if (this.filter == null) {
            throw new PebbleException(null, String.format("Filter [%s] does not exist.", filterName), this.getLineNumber(), self.getName());
        }
        Map<String, Object> namedArguments = args.getArgumentMap(self, context, this.filter);
        if (this.filter instanceof DefaultFilter) {
            try {
                input = this.getLeftExpression().evaluate(self, context);
            }
            catch (AttributeNotFoundException ex) {
                input = null;
            }
        } else {
            input = this.getLeftExpression().evaluate(self, context);
        }
        if (input instanceof SafeString && !(this.filter instanceof EscapeFilter)) {
            input = input.toString();
        }
        return this.filter.apply(input, namedArguments, self, context, this.getLineNumber());
    }
}

