/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.operator;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.node.expression.BinaryExpression;
import io.pebbletemplates.pebble.node.expression.FilterExpression;
import io.pebbletemplates.pebble.node.expression.NegativeTestExpression;
import io.pebbletemplates.pebble.node.expression.PositiveTestExpression;
import io.pebbletemplates.pebble.operator.Associativity;
import io.pebbletemplates.pebble.operator.BinaryOperator;
import io.pebbletemplates.pebble.operator.BinaryOperatorType;
import java.util.function.Supplier;

public class BinaryOperatorImpl
implements BinaryOperator {
    private final int precedence;
    private final String symbol;
    private final Supplier<? extends BinaryExpression<?>> nodeSupplier;
    private final BinaryOperatorType type;
    private final Associativity associativity;

    public BinaryOperatorImpl(String symbol, int precedence, Class<? extends BinaryExpression<?>> nodeClass, Associativity associativity) {
        this(symbol, precedence, () -> {
            try {
                return (BinaryExpression)nodeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new PebbleException(e, "Error instantiating class " + nodeClass.getName());
            }
        }, BinaryOperatorImpl.getDefaultType(nodeClass), associativity);
    }

    public BinaryOperatorImpl(String symbol, int precedence, Supplier<? extends BinaryExpression<?>> nodeSupplier, BinaryOperatorType type, Associativity associativity) {
        this.symbol = symbol;
        this.precedence = precedence;
        this.nodeSupplier = nodeSupplier;
        this.type = type;
        this.associativity = associativity;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public BinaryExpression<?> createInstance() {
        return this.nodeSupplier.get();
    }

    @Override
    public BinaryOperatorType getType() {
        return this.type;
    }

    @Override
    public Associativity getAssociativity() {
        return this.associativity;
    }

    private static BinaryOperatorType getDefaultType(Class<? extends BinaryExpression<?>> nodeClass) {
        if (FilterExpression.class.equals(nodeClass)) {
            return BinaryOperatorType.FILTER;
        }
        if (PositiveTestExpression.class.equals(nodeClass) || NegativeTestExpression.class.equals(nodeClass)) {
            return BinaryOperatorType.TEST;
        }
        return BinaryOperatorType.NORMAL;
    }
}

