/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.template;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.BlockNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.template.Block;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.GlobalContext;
import com.mitchellbosecke.pebble.template.Hierarchy;
import com.mitchellbosecke.pebble.template.Macro;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.ScopeChain;
import com.mitchellbosecke.pebble.utils.FutureWriter;
import com.mitchellbosecke.pebble.utils.Pair;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PebbleTemplateImpl
implements PebbleTemplate {
    private final PebbleEngine engine;
    private final Map<String, Block> blocks = new HashMap<String, Block>();
    private final Map<String, Macro> macros = new HashMap<String, Macro>();
    private final RenderableNode rootNode;
    private final String name;

    public PebbleTemplateImpl(PebbleEngine engine, RenderableNode root, String name) {
        this.engine = engine;
        this.rootNode = root;
        this.name = name;
    }

    @Override
    public void evaluate(Writer writer) throws IOException {
        EvaluationContextImpl context = this.initContext(null);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Locale locale) throws IOException {
        EvaluationContextImpl context = this.initContext(locale);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Map<String, Object> map) throws IOException {
        EvaluationContextImpl context = this.initContext(null);
        context.getScopeChain().pushScope(map);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Map<String, Object> map, Locale locale) throws IOException {
        EvaluationContextImpl context = this.initContext(locale);
        context.getScopeChain().pushScope(map);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer) throws IOException {
        EvaluationContextImpl context = this.initContext(null);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer, Locale locale) throws IOException {
        EvaluationContextImpl context = this.initContext(locale);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer, Map<String, Object> map) throws IOException {
        EvaluationContextImpl context = this.initContext(null);
        context.getScopeChain().pushScope(map);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer, Map<String, Object> map, Locale locale) throws IOException {
        EvaluationContextImpl context = this.initContext(locale);
        context.getScopeChain().pushScope(map);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    private void evaluate(Writer writer, EvaluationContextImpl context) throws IOException {
        if (context.getExecutorService() != null) {
            writer = new FutureWriter(writer);
        }
        this.rootNode.render(this, writer, context);
        if (context.getHierarchy().getParent() != null) {
            PebbleTemplateImpl parent = context.getHierarchy().getParent();
            context.getHierarchy().ascend();
            parent.evaluate(writer, context);
        }
        writer.flush();
    }

    private EvaluationContextImpl initContext(Locale locale) {
        locale = locale == null ? this.engine.getDefaultLocale() : locale;
        ScopeChain scopeChain = new ScopeChain();
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("locale", locale);
        globals.put("template", this);
        globals.put("_context", new GlobalContext(scopeChain));
        scopeChain.pushScope(globals);
        scopeChain.pushScope(this.engine.getExtensionRegistry().getGlobalVariables());
        return new EvaluationContextImpl(this, this.engine.isStrictVariables(), locale, this.engine.getExtensionRegistry(), this.engine.getTagCache(), this.engine.getExecutorService(), new ArrayList<PebbleTemplateImpl>(), new HashMap<String, PebbleTemplateImpl>(), scopeChain, null, this.engine.getEvaluationOptions());
    }

    public void importTemplate(EvaluationContextImpl context, String name) {
        context.getImportedTemplates().add((PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(name)));
    }

    public void importNamedTemplate(EvaluationContextImpl context, String name, String alias) {
        context.addNamedImportedTemplates(alias, (PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(name)));
    }

    public void importNamedMacrosFromTemplate(String name, List<Pair<String, String>> namedMacros) {
        PebbleTemplateImpl templateImpl = (PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(name));
        for (Pair<String, String> pair : namedMacros) {
            Macro m = templateImpl.macros.get(pair.getRight());
            this.registerMacro(pair.getLeft(), m);
        }
    }

    public PebbleTemplateImpl getNamedImportedTemplate(EvaluationContextImpl context, String alias) {
        return context.getNamedImportedTemplate(alias);
    }

    public void includeTemplate(Writer writer, EvaluationContextImpl context, String name, Map<?, ?> additionalVariables) throws IOException {
        PebbleTemplateImpl template = (PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(name));
        EvaluationContextImpl newContext = context.shallowCopyWithoutInheritanceChain(template);
        ScopeChain scopeChain = newContext.getScopeChain();
        scopeChain.pushScope();
        for (Map.Entry<?, ?> entry : additionalVariables.entrySet()) {
            scopeChain.put((String)entry.getKey(), entry.getValue());
        }
        template.evaluate(writer, newContext);
        scopeChain.popScope();
    }

    public void embedTemplate(int lineNo, Writer writer, EvaluationContextImpl context, String name, Map<?, ?> additionalVariables, List<BlockNode> overriddenBlocks) throws IOException {
        String embeddedTemplateName = this.resolveRelativePath(name);
        PebbleTemplateImpl embeddedTemplate = (PebbleTemplateImpl)this.engine.getTemplate(embeddedTemplateName);
        context.scopedShallowWithoutInheritanceChain(embeddedTemplate, additionalVariables, newContext -> {
            BodyNode embeddedTemplateBody = ((RootNode)pebbleTemplateImpl.rootNode).getBody();
            BodyNode bodyNode = new BodyNode(lineNo, Collections.singletonList(embeddedTemplateBody));
            PebbleTemplateImpl fakeRootTemplate = new PebbleTemplateImpl(this.engine, bodyNode, embeddedTemplateName);
            for (Block block : pebbleTemplateImpl.blocks.values()) {
                fakeRootTemplate.registerBlock(block);
            }
            for (BlockNode blockNode : overriddenBlocks) {
                embeddedTemplate.registerBlock(blockNode.getBlock());
            }
            newContext.getHierarchy().pushAncestor(fakeRootTemplate);
            embeddedTemplate.evaluate(writer, (EvaluationContextImpl)newContext);
        });
    }

    public boolean hasMacro(String macroName) {
        return this.macros.containsKey(macroName);
    }

    public boolean hasBlock(String blockName) {
        return this.blocks.containsKey(blockName);
    }

    public String resolveRelativePath(String relativePath) {
        String resolved = this.engine.getLoader().resolveRelativePath(relativePath, this.name);
        if (resolved == null) {
            return relativePath;
        }
        return resolved;
    }

    public void registerBlock(Block block) {
        this.blocks.put(block.getName(), block);
    }

    public void registerMacro(Macro macro) {
        if (this.macros.containsKey(macro.getName())) {
            throw new PebbleException(null, "More than one macro can not share the same name: " + macro.getName());
        }
        this.macros.put(macro.getName(), macro);
    }

    public void registerMacro(String alias, Macro macro) {
        if (this.macros.containsKey(alias)) {
            throw new PebbleException(null, "More than one macro can not share the same name: " + alias);
        }
        this.macros.put(alias, macro);
    }

    public void block(Writer writer, EvaluationContextImpl context, String blockName, boolean ignoreOverriden) throws IOException {
        Hierarchy hierarchy = context.getHierarchy();
        PebbleTemplateImpl childTemplate = hierarchy.getChild();
        if (!ignoreOverriden && childTemplate != null) {
            hierarchy.descend();
            childTemplate.block(writer, context, blockName, false);
            hierarchy.ascend();
        } else if (this.blocks.containsKey(blockName)) {
            Block block = this.blocks.get(blockName);
            block.evaluate(this, writer, context);
        } else if (hierarchy.getParent() != null) {
            PebbleTemplateImpl parent = hierarchy.getParent();
            hierarchy.ascend();
            parent.block(writer, context, blockName, true);
            hierarchy.descend();
        }
    }

    public SafeString macro(EvaluationContextImpl context, String macroName, ArgumentsNode args, boolean ignoreOverriden, int lineNumber) {
        SafeString result = null;
        boolean found = false;
        PebbleTemplateImpl childTemplate = context.getHierarchy().getChild();
        if (!ignoreOverriden && childTemplate != null) {
            found = true;
            context.getHierarchy().descend();
            result = childTemplate.macro(context, macroName, args, false, lineNumber);
            context.getHierarchy().ascend();
        } else if (this.hasMacro(macroName)) {
            found = true;
            Macro macro = this.macros.get(macroName);
            Map<String, Object> namedArguments = args.getArgumentMap(this, context, macro);
            result = new SafeString(macro.call(this, context, namedArguments));
        }
        if (!found) {
            for (PebbleTemplateImpl template : context.getImportedTemplates()) {
                if (!template.hasMacro(macroName)) continue;
                found = true;
                result = template.macro(context, macroName, args, false, lineNumber);
                break;
            }
        }
        if (!found) {
            if (context.getHierarchy().getParent() != null) {
                PebbleTemplateImpl parent = context.getHierarchy().getParent();
                context.getHierarchy().ascend();
                result = parent.macro(context, macroName, args, true, lineNumber);
                context.getHierarchy().descend();
            } else {
                throw new PebbleException(null, String.format("Function or Macro [%s] does not exist.", macroName), lineNumber, this.name);
            }
        }
        return result;
    }

    public void setParent(EvaluationContextImpl context, String parentName) {
        context.getHierarchy().pushAncestor((PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(parentName)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static class NoopWriter
    extends Writer {
        private NoopWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

