/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.mock.MockSpan;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.util.ThreadLocalScopeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockTracer
implements Tracer {
    private final List<MockSpan> finishedSpans = new ArrayList<MockSpan>();
    private final Propagator propagator;
    private final ScopeManager scopeManager;

    public MockTracer() {
        this((ScopeManager)new ThreadLocalScopeManager(), Propagator.TEXT_MAP);
    }

    public MockTracer(ScopeManager scopeManager) {
        this(scopeManager, Propagator.TEXT_MAP);
    }

    public MockTracer(ScopeManager scopeManager, Propagator propagator) {
        this.scopeManager = scopeManager;
        this.propagator = propagator;
    }

    public MockTracer(Propagator propagator) {
        this((ScopeManager)NoopScopeManager.INSTANCE, propagator);
    }

    public synchronized void reset() {
        this.finishedSpans.clear();
    }

    public synchronized List<MockSpan> finishedSpans() {
        return new ArrayList<MockSpan>(this.finishedSpans);
    }

    protected void onSpanFinished(MockSpan mockSpan) {
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.propagator.inject((MockSpan.MockContext)spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.propagator.extract(format, carrier);
    }

    public Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    synchronized void appendFinishedSpan(MockSpan mockSpan) {
        this.finishedSpans.add(mockSpan);
        this.onSpanFinished(mockSpan);
    }

    private SpanContext activeSpanContext() {
        Span span = this.activeSpan();
        if (span == null) {
            return null;
        }
        return span.context();
    }

    public final class SpanBuilder
    implements Tracer.SpanBuilder {
        private final String operationName;
        private long startMicros;
        private List<MockSpan.Reference> references = new ArrayList<MockSpan.Reference>();
        private boolean ignoringActiveSpan;
        private Map<String, Object> initialTags = new HashMap<String, Object>();

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public SpanBuilder asChildOf(SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public SpanBuilder asChildOf(Span parent) {
            if (parent == null) {
                return this;
            }
            return this.addReference("child_of", parent.context());
        }

        public SpanBuilder ignoreActiveSpan() {
            this.ignoringActiveSpan = true;
            return this;
        }

        public SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if (referencedContext != null) {
                this.references.add(new MockSpan.Reference((MockSpan.MockContext)referencedContext, referenceType));
            }
            return this;
        }

        public SpanBuilder withTag(String key, String value) {
            this.initialTags.put(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, boolean value) {
            this.initialTags.put(key, value);
            return this;
        }

        public SpanBuilder withTag(String key, Number value) {
            this.initialTags.put(key, value);
            return this;
        }

        public SpanBuilder withStartTimestamp(long microseconds) {
            this.startMicros = microseconds;
            return this;
        }

        public Scope startActive(boolean finishOnClose) {
            return MockTracer.this.scopeManager().activate((Span)this.startManual(), finishOnClose);
        }

        public MockSpan start() {
            return this.startManual();
        }

        public MockSpan startManual() {
            if (this.startMicros == 0L) {
                this.startMicros = MockSpan.nowMicros();
            }
            SpanContext activeSpanContext = MockTracer.this.activeSpanContext();
            if (this.references.isEmpty() && !this.ignoringActiveSpan && activeSpanContext != null) {
                this.references.add(new MockSpan.Reference((MockSpan.MockContext)activeSpanContext, "child_of"));
            }
            return new MockSpan(MockTracer.this, this.operationName, this.startMicros, this.initialTags, this.references);
        }
    }

    public static interface Propagator {
        public static final Propagator PRINTER = new Propagator(){

            @Override
            public <C> void inject(MockSpan.MockContext ctx, Format<C> format, C carrier) {
                System.out.println("inject(" + ctx + ", " + format + ", " + carrier + ")");
            }

            @Override
            public <C> MockSpan.MockContext extract(Format<C> format, C carrier) {
                System.out.println("extract(" + format + ", " + carrier + ")");
                return null;
            }
        };
        public static final Propagator TEXT_MAP = new Propagator(){
            public static final String SPAN_ID_KEY = "spanid";
            public static final String TRACE_ID_KEY = "traceid";
            public static final String BAGGAGE_KEY_PREFIX = "baggage-";

            @Override
            public <C> void inject(MockSpan.MockContext ctx, Format<C> format, C carrier) {
                TextMap textMap;
                if (carrier instanceof TextMap) {
                    textMap = (TextMap)carrier;
                    for (Map.Entry<String, String> entry : ctx.baggageItems()) {
                        textMap.put(BAGGAGE_KEY_PREFIX + entry.getKey(), entry.getValue());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown carrier");
                }
                textMap.put(SPAN_ID_KEY, String.valueOf(ctx.spanId()));
                textMap.put(TRACE_ID_KEY, String.valueOf(ctx.traceId()));
            }

            @Override
            public <C> MockSpan.MockContext extract(Format<C> format, C carrier) {
                Long traceId = null;
                Long spanId = null;
                HashMap<String, String> baggage = new HashMap<String, String>();
                if (carrier instanceof TextMap) {
                    TextMap textMap = (TextMap)carrier;
                    for (Map.Entry entry : textMap) {
                        if (TRACE_ID_KEY.equals(entry.getKey())) {
                            traceId = Long.valueOf((String)entry.getValue());
                            continue;
                        }
                        if (SPAN_ID_KEY.equals(entry.getKey())) {
                            spanId = Long.valueOf((String)entry.getValue());
                            continue;
                        }
                        if (!((String)entry.getKey()).startsWith(BAGGAGE_KEY_PREFIX)) continue;
                        String key = ((String)entry.getKey()).substring(BAGGAGE_KEY_PREFIX.length());
                        baggage.put(key, (String)entry.getValue());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown carrier");
                }
                if (traceId != null && spanId != null) {
                    return new MockSpan.MockContext(traceId, spanId, baggage);
                }
                return null;
            }
        };

        public <C> void inject(MockSpan.MockContext var1, Format<C> var2, C var3);

        public <C> MockSpan.MockContext extract(Format<C> var1, C var2);
    }
}

