/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.tracerresolver;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.PriorityComparator;
import io.opentracing.contrib.tracerresolver.TracerConverter;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TracerResolver {
    private static final Logger LOGGER = Logger.getLogger(TracerResolver.class.getName());
    private static final ServiceLoader<TracerResolver> RESOLVERS = ServiceLoader.load(TracerResolver.class);
    private static final ServiceLoader<TracerConverter> CONVERTERS = ServiceLoader.load(TracerConverter.class);
    private static final ServiceLoader<Tracer> FALLBACK = ServiceLoader.load(Tracer.class);

    protected abstract Tracer resolve();

    public static Tracer resolveTracer() {
        for (TracerResolver resolver : PriorityComparator.prioritize(RESOLVERS)) {
            try {
                Tracer tracer = TracerResolver.convert(resolver.resolve());
                if (tracer == null) continue;
                return TracerResolver.logResolved(tracer);
            }
            catch (RuntimeException rte) {
                LOGGER.log(Level.WARNING, "Error resolving tracer using " + resolver + ": " + rte.getMessage(), rte);
            }
        }
        for (Tracer tracer : PriorityComparator.prioritize(FALLBACK)) {
            if ((tracer = TracerResolver.convert(tracer)) == null) continue;
            return TracerResolver.logResolved(tracer);
        }
        LOGGER.log(Level.FINEST, "No tracer was resolved.");
        return null;
    }

    public static void reload() {
        RESOLVERS.reload();
        CONVERTERS.reload();
        FALLBACK.reload();
        LOGGER.log(Level.FINER, "Tracer resolvers were reloaded.");
    }

    private static Tracer convert(Tracer resolved) {
        if (resolved != null) {
            for (TracerConverter converter : PriorityComparator.prioritize(CONVERTERS)) {
                try {
                    Tracer converted = converter.convert(resolved);
                    LOGGER.log(Level.FINEST, "Converted {0} using {1}: {2}.", new Object[]{resolved, converter, converted});
                    resolved = converted;
                }
                catch (RuntimeException rte) {
                    LOGGER.log(Level.WARNING, "Error converting " + resolved + " with " + converter + ": " + rte.getMessage(), rte);
                }
                if (resolved != null) continue;
                break;
            }
        }
        return resolved;
    }

    private static Tracer logResolved(Tracer resolvedTracer) {
        LOGGER.log(Level.FINER, "Resolved tracer: {0}.", resolvedTracer);
        return resolvedTracer;
    }
}

