/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.starter.client;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.RestTemplateSpanDecorator;
import io.opentracing.contrib.spring.web.client.TracingRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

public class TracingRestTemplateCustomizer
implements RestTemplateCustomizer {
    private final Tracer tracer;
    private final List<RestTemplateSpanDecorator> spanDecorators;

    public TracingRestTemplateCustomizer(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators) {
        this.tracer = Objects.requireNonNull(tracer);
        this.spanDecorators = Objects.requireNonNull(spanDecorators);
    }

    public void customize(RestTemplate restTemplate) {
        ArrayList<TracingRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
        for (ClientHttpRequestInterceptor clientHttpRequestInterceptor : interceptors) {
            if (!(clientHttpRequestInterceptor instanceof TracingRestTemplateInterceptor)) continue;
            return;
        }
        interceptors = new ArrayList<TracingRestTemplateInterceptor>(interceptors);
        interceptors.add(new TracingRestTemplateInterceptor(this.tracer, this.spanDecorators));
        restTemplate.setInterceptors(interceptors);
    }
}

