/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.synchronization;

import org.jboss.byteman.rule.exception.ExecuteException;

public class Waiter {
    private Object waiterFor;
    private boolean signalled;
    private boolean killed;
    private boolean waiting;

    public Waiter(Object object) {
        this(object, false, false);
    }

    public Waiter(Object object, boolean signalled, boolean killed) {
        this.waiterFor = object;
        this.signalled = signalled;
        this.killed = killed;
        this.waiting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(long millisecs) {
        long start = System.currentTimeMillis();
        long waitForMillis = millisecs;
        Waiter waiter = this;
        synchronized (waiter) {
            this.waiting = true;
            while (!this.signalled && waitForMillis >= 0L) {
                try {
                    if (waitForMillis == 0L && millisecs > 0L) break;
                    this.wait(waitForMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.signalled) continue;
                waitForMillis = millisecs == 0L ? 0L : millisecs + start - System.currentTimeMillis();
            }
            if (this.signalled) {
                this.notifyAll();
            }
        }
        if (this.killed) {
            throw new ExecuteException("Waiter.waitFor : killed thread waiting for " + this.waiterFor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signalWake() {
        boolean result;
        Waiter waiter = this;
        synchronized (waiter) {
            result = this.signalled;
            if (!this.signalled) {
                this.signalled = true;
                this.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signalThrow() {
        boolean result;
        Waiter waiter = this;
        synchronized (waiter) {
            result = this.signalled;
            if (!this.signalled) {
                this.signalled = true;
                this.killed = true;
                this.notifyAll();
            }
        }
        return result;
    }

    public boolean waiting() {
        return this.waiting;
    }

    public boolean isSignalled() {
        return this.signalled;
    }
}

