/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class StringPlusExpression
extends BinaryOperExpression {
    public StringPlusExpression(Rule rule, ParseNode token, Expression left, Expression right) {
        super(rule, 8707, Type.STRING, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.STRING);
        Type type2 = this.getOperand(1).typeCheck(Type.STRING);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(Type.STRING)) {
            throw new TypeException("StringPlusExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Object value1 = this.getOperand(0).interpret(helper);
        Object value2 = this.getOperand(1).interpret(helper);
        String string1 = value1.toString();
        String string2 = value2 == null ? "null" : value2.toString();
        return string1 + string2;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        Type oper0Type = oper0.getType();
        Type oper1Type = oper1.getType();
        if (this.rule.requiresAccess(oper0Type)) {
            oper0Type = Type.OBJECT;
        }
        if (this.rule.requiresAccess(oper1Type)) {
            oper1Type = Type.OBJECT;
        }
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        oper0.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper0Type, this.type);
        oper1.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper1Type, this.type);
        Label skiptarget = new Label();
        mv.visitInsn(89);
        compileContext.addStackCount(1);
        mv.visitJumpInsn(199, skiptarget);
        compileContext.addStackCount(-1);
        mv.visitInsn(87);
        mv.visitLdcInsn("null");
        mv.visitLabel(skiptarget);
        mv.visitMethodInsn(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        compileContext.addStackCount(-1);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("StringPlusExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

