/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ShiftExpression
extends BinaryOperExpression {
    public ShiftExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) throws TypeException {
        super(rule, oper, left.getType(), token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        block5: {
            block6: {
                Type type2;
                Type type1;
                block4: {
                    type1 = this.getOperand(0).typeCheck(Type.N);
                    type2 = this.getOperand(1).typeCheck(Type.N);
                    this.type = type1;
                    if (!this.type.isFloating()) break block4;
                    this.type = Type.J;
                    break block5;
                }
                if (type1 == Type.C) break block6;
                if (type2 != Type.C) break block5;
            }
            throw new TypeException("ShiftExpression.typeCheck : invalid operand type java.lang.character " + this.getPos());
        }
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("ShiftExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            long result;
            Number value1 = (Number)this.getOperand(0).interpret(helper);
            Number value2 = (Number)this.getOperand(1).interpret(helper);
            int shift = value2.intValue();
            if (this.type == Type.B) {
                byte result2;
                byte b1 = value1.byteValue();
                switch (this.oper) {
                    case 8451: {
                        result2 = (byte)(b1 >>> shift);
                        break;
                    }
                    case 8452: {
                        result2 = (byte)(b1 >> shift);
                        break;
                    }
                    case 8453: {
                        result2 = (byte)(b1 << shift);
                        break;
                    }
                    default: {
                        result2 = 0;
                    }
                }
                return result2;
            }
            if (this.type == Type.S) {
                short result3;
                short s1 = value1.shortValue();
                switch (this.oper) {
                    case 8451: {
                        result3 = (short)(s1 >>> shift);
                        break;
                    }
                    case 8452: {
                        result3 = (short)(s1 >> shift);
                        break;
                    }
                    case 8453: {
                        result3 = (short)(s1 << shift);
                        break;
                    }
                    default: {
                        result3 = 0;
                    }
                }
                return result3;
            }
            if (this.type == Type.I) {
                int result4;
                int i1 = value1.intValue();
                switch (this.oper) {
                    case 8451: {
                        result4 = i1 >>> shift;
                        break;
                    }
                    case 8452: {
                        result4 = i1 >> shift;
                        break;
                    }
                    case 8453: {
                        result4 = i1 << shift;
                        break;
                    }
                    default: {
                        result4 = 0;
                    }
                }
                return result4;
            }
            long l1 = value1.longValue();
            switch (this.oper) {
                case 8451: {
                    result = l1 >>> shift;
                    break;
                }
                case 8452: {
                    result = l1 >> shift;
                    break;
                }
                case 8453: {
                    result = l1 << shift;
                    break;
                }
                default: {
                    result = 0L;
                }
            }
            return result;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("ShiftExpression.interpret : unexpected exception for operation " + this.token + this.getPos() + " in rule " + helper.getName(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int expected = 0;
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        oper0.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper0.getType(), this.type);
        oper1.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper1.getType(), Type.I);
        if (this.type == Type.B || this.type == Type.S || this.type == Type.I) {
            switch (this.oper) {
                case 8453: {
                    mv.visitInsn(120);
                    break;
                }
                case 8452: {
                    if (this.type == Type.C) {
                        mv.visitInsn(124);
                        break;
                    }
                    mv.visitInsn(122);
                    break;
                }
                case 8451: {
                    mv.visitInsn(124);
                }
            }
            if (this.type == Type.B) {
                mv.visitInsn(145);
            } else if (this.type == Type.S) {
                mv.visitInsn(147);
            } else if (this.type == Type.C) {
                mv.visitInsn(146);
            }
            compileContext.addStackCount(-1);
            expected = 1;
        } else if (this.type == Type.J) {
            switch (this.oper) {
                case 8453: {
                    mv.visitInsn(121);
                    break;
                }
                case 8452: {
                    mv.visitInsn(123);
                    break;
                }
                case 8451: {
                    mv.visitInsn(125);
                }
            }
            compileContext.addStackCount(-1);
            expected = 2;
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ShiftExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

