/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class PlusExpression
extends BinaryOperExpression {
    public PlusExpression(Rule rule, ParseNode token, Expression left, Expression right) {
        super(rule, 8707, Type.UNDEFINED, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(expected.isNumeric() ? expected : Type.UNDEFINED);
        if (type1.isNumeric()) {
            Type type2 = this.getOperand(1).typeCheck(Type.N);
            this.type = Type.promote(type1, type2);
        } else if (type1.isString()) {
            Type type2 = this.getOperand(1).typeCheck(Type.STRING);
            this.type = Type.STRING;
        } else {
            throw new TypeException("PlusExpression.typeCheck : invalid argument type " + type1.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Object value1 = this.getOperand(0).interpret(helper);
        Object value2 = this.getOperand(1).interpret(helper);
        if (this.type == Type.STRING) {
            String s1 = value1 != null ? value1.toString() : "null";
            String s2 = value2 != null ? value2.toString() : "null";
            return s1 + s2;
        }
        if (value1 instanceof Character) {
            value1 = (int)((Character)value1).charValue();
        }
        if (value2 instanceof Character) {
            value2 = (int)((Character)value2).charValue();
        }
        Number n1 = (Number)value1;
        Number n2 = (Number)value2;
        if (this.type == Type.B) {
            byte b1 = n1.byteValue();
            byte b2 = n2.byteValue();
            byte result = (byte)(b1 + b2);
            return result;
        }
        if (this.type == Type.S) {
            short s1 = n1.shortValue();
            short s2 = n2.shortValue();
            short result = (short)(s1 + s2);
            return result;
        }
        if (this.type == Type.I) {
            int i1 = n1.intValue();
            int i2 = n2.intValue();
            int result = i1 + i2;
            return result;
        }
        if (this.type == Type.J) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            long result = l1 + l2;
            return result;
        }
        if (this.type == Type.F) {
            float f1 = n1.floatValue();
            float f2 = n2.floatValue();
            float result = f1 + f2;
            return Float.valueOf(result);
        }
        if (this.type == Type.D) {
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            double result = d1 + d2;
            return result;
        }
        char c1 = (char)n1.intValue();
        char c2 = (char)n2.intValue();
        char result = (char)(c1 + c2);
        return Character.valueOf(result);
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        int currentStack = compileContext.getStackCount();
        int expected = 0;
        oper0.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper0.getType(), this.type);
        oper1.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper1.getType(), this.type);
        if (this.type == Type.STRING) {
            expected = 1;
            mv.visitMethodInsn(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
            compileContext.addStackCount(-1);
        } else if (this.type == Type.B) {
            expected = 1;
            mv.visitInsn(96);
            mv.visitInsn(145);
            compileContext.addStackCount(-1);
        } else if (this.type == Type.S) {
            expected = 1;
            mv.visitInsn(96);
            mv.visitInsn(147);
            compileContext.addStackCount(-1);
        } else if (this.type == Type.C) {
            expected = 1;
            mv.visitInsn(96);
            mv.visitInsn(146);
            compileContext.addStackCount(-1);
        } else if (this.type == Type.I) {
            expected = 1;
            mv.visitInsn(96);
            compileContext.addStackCount(-1);
        } else if (this.type == Type.J) {
            expected = 2;
            mv.visitInsn(97);
            compileContext.addStackCount(-2);
        } else if (this.type == Type.F) {
            expected = 1;
            mv.visitInsn(98);
            compileContext.addStackCount(-1);
        } else if (this.type == Type.D) {
            expected = 2;
            mv.visitInsn(99);
            compileContext.addStackCount(-2);
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("PlusExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }
}

