/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.ArrayInitExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class NewExpression
extends Expression {
    private String typeName;
    private List<Expression> arguments;
    private List<Expression> arrayDims;
    private ArrayInitExpression arrayInits;
    private List<Type> argumentTypes;
    private List<Type> paramTypes;
    private Constructor constructor;
    private int arrayDimCount;
    private int arrayDimDefinedCount;
    private int arrayInitsCount;

    public NewExpression(Rule rule, ParseNode token, List<Expression> arguments, List<Expression> arraySizes, ArrayInitExpression arrayInits) {
        super(rule, Type.UNDEFINED, token);
        this.typeName = token.getText();
        this.arguments = arguments;
        this.arrayDims = arraySizes;
        this.arrayInits = arrayInits;
        this.arrayDimCount = arraySizes.size();
        this.arrayDimDefinedCount = 0;
        this.argumentTypes = null;
        this.constructor = null;
    }

    @Override
    public void bind() throws TypeException {
        Iterator<Expression> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            iterator.next().bind();
        }
        for (Expression expr : this.arrayDims) {
            if (expr == null) continue;
            expr.bind();
            ++this.arrayDimDefinedCount;
        }
        if (this.arrayInits != null) {
            this.arrayInits.bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        this.type = Type.dereference(typeGroup.create(this.typeName));
        if (this.type == null || this.type.isUndefined()) {
            throw new TypeException("NewExpression.typeCheck : unknown type " + this.typeName + this.getPos());
        }
        if (this.type.isObject() && this.arrayDimCount == 0) {
            Class clazz = this.type.getTargetClass();
            int arity = this.arguments.size();
            Constructor<?>[] constructors = clazz.getConstructors();
            List<Constructor> candidates = new ArrayList<Constructor>();
            boolean duplicates = false;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length != arity) continue;
                candidates.add(constructor);
            }
            this.argumentTypes = new ArrayList<Type>();
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (candidates.isEmpty()) {
                    throw new TypeException("NewExpression.typeCheck : invalid constructor for target class " + this.typeName + this.getPos());
                }
                Class candidateClass = this.getCandidateArgClass(candidates, i);
                Type candidateType = candidateClass != null ? typeGroup.ensureType(candidateClass) : Type.UNDEFINED;
                Type argType = this.arguments.get(i).typeCheck(candidateType);
                this.argumentTypes.add(argType);
                if (candidateType != Type.UNDEFINED) continue;
                candidates = this.pruneCandidates(candidates, i, argType.getTargetClass());
            }
            if (candidates.isEmpty()) {
                throw new TypeException("NewExpression.typeCheck : invalid constructor for target class " + this.typeName + this.getPos());
            }
            if (candidates.size() > 1) {
                throw new TypeException("NewExpression.typeCheck : ambiguous constructor signature for target class " + this.typeName + this.getPos());
            }
            this.constructor = (Constructor)candidates.get(0);
            this.paramTypes = new ArrayList<Type>();
            Class<?>[] paramClasses = this.constructor.getParameterTypes();
            for (int i = 0; i < this.arguments.size(); ++i) {
                this.paramTypes.add(typeGroup.ensureType(paramClasses[i]));
            }
        } else if (this.arrayDimCount == 0) {
            throw new TypeException("NewExpression.typeCheck : invalid type for new operation " + this.getPos());
        }
        if (this.arrayDimCount > 0 && this.arrayDimDefinedCount == 0 && this.arrayInits == null) {
            throw new TypeException("NewExpression.typeCheck : array dimension missing " + this.getPos());
        }
        if (this.arrayDimCount > 127) {
            throw new TypeException("NewExpression.typeCheck : too many array dimensions " + this.getPos());
        }
        if (this.arrayInits != null) {
            if (this.arrayDimCount == 0) {
                throw new TypeException("NewExpression.typeCheck : cannot specify initializer for non array" + this.getPos());
            }
            if (this.arrayDimDefinedCount != 0) {
                throw new TypeException("NewExpression.typeCheck : cannot specify both array dimensions and initializer " + this.getPos());
            }
        }
        for (int i = 0; i < this.arrayDimCount; ++i) {
            if (i < this.arrayDimDefinedCount) {
                Expression expr = this.arrayDims.get(i);
                expr.typeCheck(Type.I);
            }
            this.type = typeGroup.createArray(this.type);
        }
        if (this.arrayInits != null) {
            this.arrayInits.typeCheck(this.type);
        }
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("NewExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    public Class getCandidateArgClass(List<Constructor> candidates, int argIdx) {
        Class<?> argClazz = null;
        for (Constructor c : candidates) {
            Class<?> nextClazz = c.getParameterTypes()[argIdx];
            if (argClazz == null) {
                argClazz = nextClazz;
                continue;
            }
            if (argClazz == nextClazz) continue;
            return null;
        }
        return argClazz;
    }

    public List<Constructor> pruneCandidates(List<Constructor> candidates, int argIdx, Class argClazz) {
        int i = 0;
        while (i < candidates.size()) {
            Constructor c = candidates.get(i);
            Class<?> nextClazz = c.getParameterTypes()[argIdx];
            if (nextClazz == argClazz || nextClazz.isAssignableFrom(argClazz)) {
                ++i;
                continue;
            }
            candidates.remove(i);
        }
        return candidates;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        if (this.arrayDimCount == 0) {
            int l = this.arguments.size();
            Object[] callArgs = new Object[l];
            for (int i = 0; i < l; ++i) {
                callArgs[i] = this.arguments.get(i).interpret(helper);
            }
            try {
                Object result = this.constructor.newInstance(callArgs);
                return result;
            }
            catch (InstantiationException e) {
                throw new ExecuteException("NewExpression.interpret : unable to instantiate class " + this.typeName + this.getPos(), e);
            }
            catch (IllegalAccessException e) {
                throw new ExecuteException("NewExpression.interpret : unable to access class " + this.typeName + this.getPos(), e);
            }
            catch (InvocationTargetException e) {
                throw new ExecuteException("NewExpression.interpret : unable to invoke constructor for class " + this.typeName + this.getPos(), e);
            }
        }
        if (this.arrayInits != null) {
            Object result = this.arrayInits.interpret(helper);
            return result;
        }
        int[] dims = new int[this.arrayDimDefinedCount];
        Type componentType = this.type;
        for (int i = 0; i < this.arrayDimDefinedCount; ++i) {
            int dimValue;
            Expression dim = this.arrayDims.get(i);
            dims[i] = dimValue = ((Integer)dim.interpret(helper)).intValue();
            componentType = componentType.getBaseType();
        }
        try {
            Object result = Array.newInstance(componentType.getTargetClass(), dims);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("NewExpression.interpret : unable to instantiate array " + this.typeName + this.getPos(), e);
        }
        catch (NegativeArraySizeException e) {
            throw new ExecuteException("NewExpression.interpret : unable to instantiate array " + this.typeName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        int extraParams = 0;
        if (this.arrayDimCount == 0) {
            String instantiatedClassName = this.type.getInternalName();
            mv.visitTypeInsn(187, instantiatedClassName);
            compileContext.addStackCount(1);
            mv.visitInsn(89);
            compileContext.addStackCount(1);
            int argCount = this.arguments.size();
            for (int i = 0; i < argCount; ++i) {
                Type argType = this.argumentTypes.get(i);
                Type paramType = this.paramTypes.get(i);
                int paramCount = paramType.getNBytes() > 4 ? 2 : 1;
                extraParams += paramCount;
                this.arguments.get(i).compile(mv, compileContext);
                compileContext.compileTypeConversion(argType, paramType);
            }
            mv.visitMethodInsn(183, instantiatedClassName, "<init>", this.getDescriptor());
            compileContext.addStackCount(-(extraParams + 1));
        } else if (this.arrayInits != null) {
            this.arrayInits.compile(mv, compileContext);
        } else if (this.arrayDimCount == 1) {
            Type baseType = this.type.getBaseType();
            this.arrayDims.get(0).compile(mv, compileContext);
            if (baseType.isObject()) {
                mv.visitTypeInsn(189, baseType.getInternalName());
            } else {
                int operand = 0;
                if (baseType.equals(Type.Z)) {
                    operand = 4;
                } else if (baseType.equals(Type.B)) {
                    operand = 8;
                } else if (baseType.equals(Type.S)) {
                    operand = 9;
                } else if (baseType.equals(Type.C)) {
                    operand = 5;
                } else if (baseType.equals(Type.I)) {
                    operand = 10;
                } else if (baseType.equals(Type.J)) {
                    operand = 11;
                } else if (baseType.equals(Type.F)) {
                    operand = 6;
                } else if (baseType.equals(Type.D)) {
                    operand = 7;
                }
                mv.visitIntInsn(188, operand);
            }
        } else {
            for (int i = 0; i < this.arrayDimDefinedCount; ++i) {
                this.arrayDims.get(i).compile(mv, compileContext);
            }
            mv.visitMultiANewArrayInsn(this.type.getInternalName(), this.arrayDimDefinedCount);
            compileContext.addStackCount(1 - this.arrayDimDefinedCount);
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("NewExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }

    private String getDescriptor() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int nParams = this.paramTypes.size();
        for (int i = 0; i < nParams; ++i) {
            buffer.append(this.paramTypes.get(i).getInternalName(true, true));
        }
        buffer.append(")V");
        return buffer.toString();
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write("new ");
        if (this.type == null || Type.UNDEFINED == this.type) {
            stringWriter.write(this.typeName);
        } else {
            stringWriter.write(this.type.getName());
        }
        String separator = "";
        if (this.arrayDimCount == 0) {
            stringWriter.write("(");
            for (Expression argument : this.arguments) {
                stringWriter.write(separator);
                argument.writeTo(stringWriter);
                separator = ",";
            }
            stringWriter.write(")");
        } else {
            for (int i = 0; i < this.arrayDimCount; ++i) {
                stringWriter.write("[]");
            }
            if (this.arrayInits != null) {
                this.arrayInits.writeTo(stringWriter);
            }
        }
    }
}

