/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class Main {
    public static boolean firstTime = true;
    public static final String BYTEMAN_PREFIX = "org.jboss.byteman.";
    public static final String BYTEMAN_AGENT_LOADED = "org.jboss.byteman.agent.loaded";
    private static final String PORT_PREFIX = "port:";
    private static final String ADDRESS_PREFIX = "address:";
    private static final String BOOT_PREFIX = "boot:";
    private static final String SYS_PREFIX = "sys:";
    private static final String POLICY_PREFIX = "policy:";
    private static final String SCRIPT_PREFIX = "script:";
    private static final String RESOURCE_SCRIPT_PREFIX = "resourcescript:";
    private static final String LISTENER_PREFIX = "listener:";
    private static final String REDEFINE_PREFIX = "redefine:";
    private static final String PROP_PREFIX = "prop:";
    private static final String MANAGER_PREFIX = "manager:";
    private static final String MODULE_PREFIX = "modules:";
    private static final String TRANSFORMER_NAME = "org.jboss.byteman.agent.Transformer";
    private static final String RETRANSFORMER_NAME = "org.jboss.byteman.agent.Retransformer";
    private static final String MANAGER_NAME = "org.jboss.byteman.agent.TransformListener";
    private static final String MODULE_SYSTEM_NAME = "org.jboss.byteman.modules.ModuleSystem";
    private static List<String> bootJarPaths = new ArrayList<String>();
    private static List<String> sysJarPaths = new ArrayList<String>();
    private static List<String> scriptPaths = new ArrayList<String>();
    private static List<String> resourcescriptPaths = new ArrayList<String>();
    private static List<String> scripts = new ArrayList<String>();
    private static String hostname = null;
    private static Integer port = null;
    private static String managerClassName = null;
    private static String moduleSystemName = null;
    private static String moduleSystemArgs = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String args, Instrumentation inst) throws Exception {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Method method;
            ClassFileTransformer transformer;
            Constructor<?> constructor;
            Class<?> transformerClazz;
            String ruleScript;
            byte[] bytes;
            if (!firstTime) {
                throw new Exception("Main : attempting to load Byteman agent more than once");
            }
            firstTime = false;
            System.setProperty(BYTEMAN_AGENT_LOADED, Boolean.TRUE.toString());
            // ** MonitorExit[clazz] (shouldn't be in output)
            boolean installPolicy = false;
            if (args != null) {
                String[] argsArray = args.split(",");
                for (String arg : argsArray) {
                    int index;
                    String value;
                    if (arg.startsWith(BOOT_PREFIX)) {
                        bootJarPaths.add(arg.substring(BOOT_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(SYS_PREFIX)) {
                        sysJarPaths.add(arg.substring(SYS_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(ADDRESS_PREFIX)) {
                        hostname = arg.substring(ADDRESS_PREFIX.length(), arg.length());
                        if (managerClassName != null) continue;
                        managerClassName = MANAGER_NAME;
                        continue;
                    }
                    if (arg.startsWith(PORT_PREFIX)) {
                        try {
                            port = Integer.valueOf(arg.substring(PORT_PREFIX.length(), arg.length()));
                            if (port <= 0) {
                                System.err.println("Invalid port specified [" + port + "]");
                                port = null;
                                continue;
                            }
                            if (managerClassName != null) continue;
                            managerClassName = MANAGER_NAME;
                        }
                        catch (Exception e) {
                            System.err.println("Invalid port specified [" + arg + "]. Cause: " + e);
                        }
                        continue;
                    }
                    if (arg.startsWith(SCRIPT_PREFIX)) {
                        scriptPaths.add(arg.substring(SCRIPT_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(RESOURCE_SCRIPT_PREFIX)) {
                        resourcescriptPaths.add(arg.substring(RESOURCE_SCRIPT_PREFIX.length(), arg.length()));
                        continue;
                    }
                    if (arg.startsWith(LISTENER_PREFIX)) {
                        value = arg.substring(LISTENER_PREFIX.length(), arg.length());
                        if (Boolean.parseBoolean(value)) {
                            managerClassName = MANAGER_NAME;
                            continue;
                        }
                        managerClassName = null;
                        continue;
                    }
                    if (arg.startsWith(REDEFINE_PREFIX)) {
                        value = arg.substring(REDEFINE_PREFIX.length(), arg.length());
                        if (Boolean.parseBoolean(value)) {
                            managerClassName = MANAGER_NAME;
                            continue;
                        }
                        managerClassName = null;
                        continue;
                    }
                    if (arg.startsWith(PROP_PREFIX)) {
                        String prop = arg.substring(PROP_PREFIX.length(), arg.length());
                        String value2 = "";
                        if (prop.startsWith(BYTEMAN_PREFIX)) {
                            index = prop.indexOf(61);
                            if (index > 0) {
                                if (index == prop.length() - 1) {
                                    prop = prop.substring(0, index);
                                } else {
                                    value2 = prop.substring(index + 1);
                                    prop = prop.substring(0, index);
                                }
                            }
                            System.out.println("Setting " + prop + "=" + value2);
                            System.setProperty(prop, value2);
                            continue;
                        }
                        System.err.println("Invalid property : " + prop);
                        continue;
                    }
                    if (arg.startsWith(POLICY_PREFIX)) {
                        value = arg.substring(POLICY_PREFIX.length(), arg.length());
                        installPolicy = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (arg.startsWith(MANAGER_PREFIX)) {
                        managerClassName = arg.substring(MANAGER_PREFIX.length(), arg.length());
                        if (managerClassName.length() != 0) continue;
                        managerClassName = null;
                        continue;
                    }
                    if (arg.startsWith(MODULE_PREFIX)) {
                        String mod = arg.substring(MODULE_PREFIX.length(), arg.length());
                        String moduleArgs = "";
                        index = mod.indexOf(61);
                        if (index > 0) {
                            if (index == mod.length() - 1) {
                                mod = mod.substring(0, index);
                            } else {
                                moduleArgs = mod.substring(index + 1);
                                mod = mod.substring(0, index);
                            }
                        }
                        moduleSystemName = mod;
                        moduleSystemArgs = moduleArgs;
                        continue;
                    }
                    System.err.println("org.jboss.byteman.agent.Main:\n  illegal agent argument : " + arg + "\n  valid arguments are boot:<path-to-jar>, sys:<path-to-jar>, script:<path-to-script> or listener:<true-or-false>");
                }
            }
            for (String string : bootJarPaths) {
                try {
                    JarFile jarfile = new JarFile(new File(string));
                    inst.appendToBootstrapClassLoaderSearch(jarfile);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: unable to open boot jar file : " + string);
                    throw ioe;
                }
            }
            for (String string : sysJarPaths) {
                try {
                    JarFile jarfile = new JarFile(new File(string));
                    inst.appendToSystemClassLoaderSearch(jarfile);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: unable to open system jar file : " + string);
                    throw ioe;
                }
            }
            Socket dummy = new Socket();
            for (String scriptPath : scriptPaths) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(scriptPath);
                    bytes = new byte[fis.available()];
                    fis.read(bytes);
                    ruleScript = new String(bytes);
                    scripts.add(ruleScript);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: unable to read rule script file : " + scriptPath);
                    throw ioe;
                }
                finally {
                    if (fis == null) continue;
                    fis.close();
                }
            }
            for (String scriptPath : resourcescriptPaths) {
                try {
                    InputStream is = ClassLoader.getSystemResourceAsStream(scriptPath);
                    if (is == null) {
                        throw new Exception("org.jboss.byteman.agent.Main: could not read rule script resource file : " + scriptPath);
                    }
                    bytes = new byte[is.available()];
                    is.read(bytes);
                    ruleScript = new String(bytes);
                    scripts.add(ruleScript);
                    scriptPaths.add(scriptPath);
                }
                catch (IOException ioe) {
                    System.err.println("org.jboss.byteman.agent.Main: error reading rule script resource file : " + scriptPath);
                    throw ioe;
                }
            }
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (moduleSystemName == null) {
                moduleSystemName = "org.jboss.byteman.modules.NonModuleSystem";
            }
            Class<?> moduleSystemInteraceClazz = classLoader.loadClass(MODULE_SYSTEM_NAME);
            Class<?> moduleSystemImplClazz = classLoader.loadClass(moduleSystemName);
            Object moduleSystem = moduleSystemImplClazz.newInstance();
            Method moduleSystemInit = moduleSystemInteraceClazz.getMethod("initialize", String.class);
            moduleSystemInit.invoke(moduleSystem, moduleSystemArgs);
            boolean isRedefine = inst.isRedefineClassesSupported();
            if (managerClassName != null && isRedefine) {
                transformerClazz = classLoader.loadClass(RETRANSFORMER_NAME);
                constructor = transformerClazz.getConstructor(Instrumentation.class, moduleSystemInteraceClazz, List.class, List.class, Boolean.TYPE);
                transformer = (ClassFileTransformer)constructor.newInstance(inst, moduleSystem, scriptPaths, scripts, isRedefine);
            } else {
                transformerClazz = classLoader.loadClass(TRANSFORMER_NAME);
                constructor = transformerClazz.getConstructor(Instrumentation.class, moduleSystemInteraceClazz, List.class, List.class, Boolean.TYPE);
                transformer = (ClassFileTransformer)constructor.newInstance(inst, moduleSystem, scriptPaths, scripts, isRedefine);
            }
            inst.addTransformer(transformer, true);
            if (managerClassName != null && isRedefine) {
                Class<?> managerClazz = classLoader.loadClass(managerClassName);
                try {
                    Method method2 = managerClazz.getMethod("initialize", transformerClazz, String.class, Integer.class);
                    method2.invoke(null, transformer, hostname, port);
                }
                catch (NoSuchMethodException e) {
                    Method method3 = managerClazz.getMethod("initialize", transformerClazz);
                    method3.invoke(null, transformer);
                }
            }
            if (installPolicy) {
                method = transformerClazz.getMethod("installPolicy", new Class[0]);
                method.invoke((Object)transformer, new Object[0]);
            }
            if (isRedefine) {
                method = transformerClazz.getMethod("installBootScripts", new Class[0]);
                method.invoke((Object)transformer, new Object[0]);
            }
            return;
        }
    }

    public static void agentmain(String args, Instrumentation inst) throws Exception {
        Main.premain(args, inst);
    }
}

