/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.byteman.agent.Retransformer;

public class OpenTracingManager {
    private static Logger log = Logger.getLogger(OpenTracingManager.class.getName());
    private static final String AGENT_RULES = "otarules.btm";
    private static Retransformer transformer;

    public static void initialize(Retransformer trans) throws Exception {
        transformer = trans;
        OpenTracingManager.loadRules(ClassLoader.getSystemClassLoader());
    }

    public static void loadRules(ClassLoader classLoader) {
        if (transformer == null) {
            log.severe("Attempt to load OpenTracing agent rules before transformer initialized");
            return;
        }
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> scriptNames = new ArrayList<String>();
        try {
            Enumeration<URL> iter = classLoader.getResources(AGENT_RULES);
            while (iter.hasMoreElements()) {
                OpenTracingManager.loadRules(iter.nextElement().toURI(), scriptNames, scripts);
            }
            StringWriter sw = new StringWriter();
            try (PrintWriter writer = new PrintWriter(sw);){
                try {
                    transformer.installScript(scripts, scriptNames, writer);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to install scripts", e);
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest(sw.toString());
            }
        }
        catch (IOException | URISyntaxException e) {
            log.log(Level.SEVERE, "Failed to load OpenTracing agent rules", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("OpenTracing Agent rules loaded");
        }
    }

    private static void loadRules(URI uri, List<String> scriptNames, List<String> scripts) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Load rules from URI = " + uri);
        }
        StringBuilder str = new StringBuilder();
        try (InputStream is = uri.toURL().openStream();){
            int len;
            byte[] b = new byte[10240];
            while ((len = is.read(b)) != -1) {
                str.append(new String(b, 0, len));
            }
        }
        scripts.add(str.toString());
        scriptNames.add(uri.toString());
    }
}

