/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.agent;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class OpenTracingHelper
extends Helper {
    private static final Logger log = Logger.getLogger(OpenTracingHelper.class.getName());
    private static Tracer tracer;
    private static final Map<Object, Span> spanAssociations;
    private static final Map<Object, Span> finished;
    private static final Map<Object, Integer> state;
    private static final Object SYNC;

    public OpenTracingHelper(Rule rule) {
        super(rule);
    }

    public Tracer getTracer() {
        if (tracer == null) {
            this.initTracer();
        }
        return tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTracer() {
        Object object = SYNC;
        synchronized (object) {
            if (tracer == null) {
                Tracer resolved;
                if (!GlobalTracer.isRegistered() && (resolved = TracerResolver.resolveTracer()) != null) {
                    try {
                        GlobalTracer.register(resolved);
                    }
                    catch (RuntimeException re) {
                        log.log(Level.WARNING, "Failed to register tracer '" + resolved + "'", re);
                    }
                }
                tracer = new AgentTracer(GlobalTracer.get());
            }
        }
    }

    public void associateSpan(Object obj, Span span) {
        spanAssociations.put(obj, span);
    }

    public Span retrieveSpan(Object obj) {
        return spanAssociations.get(obj);
    }

    public void finishedSpan(Object key, Span span) {
        finished.put(key, span);
    }

    public boolean isFinished(Object key) {
        return finished.containsKey(key);
    }

    public void setState(Object obj, int value) {
        state.put(obj, new Integer(value));
    }

    public int getState(Object obj) {
        Integer value = state.get(obj);
        return value == null ? 0 : value;
    }

    public boolean ignore(Object obj) {
        boolean ignore = false;
        if (obj instanceof HttpURLConnection) {
            String value = ((HttpURLConnection)obj).getRequestProperty("opentracing.ignore");
            boolean bl = ignore = value != null && value.equalsIgnoreCase("true");
        }
        if (ignore && log.isLoggable(Level.FINEST)) {
            log.finest("Ignoring request because the property [opentracing.ignore] is present.");
        }
        return ignore;
    }

    static {
        spanAssociations = Collections.synchronizedMap(new WeakHashMap());
        finished = Collections.synchronizedMap(new WeakHashMap());
        state = Collections.synchronizedMap(new WeakHashMap());
        SYNC = new Object();
    }

    public static class AgentSpanBuilder
    implements Tracer.SpanBuilder {
        private Tracer.SpanBuilder spanBuilder;

        public AgentSpanBuilder(Tracer.SpanBuilder spanBuilder) {
            this.spanBuilder = spanBuilder;
        }

        @Override
        public Tracer.SpanBuilder addReference(String type, SpanContext ctx) {
            if (ctx != null) {
                this.spanBuilder.addReference(type, ctx);
            }
            return this;
        }

        @Override
        public Tracer.SpanBuilder asChildOf(SpanContext ctx) {
            if (ctx != null) {
                this.spanBuilder.asChildOf(ctx);
            }
            return this;
        }

        @Override
        public Tracer.SpanBuilder asChildOf(Span span) {
            if (span != null) {
                this.spanBuilder.asChildOf(span);
            }
            return this;
        }

        @Override
        public Span start() {
            return this.spanBuilder.start();
        }

        @Override
        public Tracer.SpanBuilder withStartTimestamp(long ts) {
            this.spanBuilder.withStartTimestamp(ts);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String name, String value) {
            this.spanBuilder.withTag(name, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String name, boolean value) {
            this.spanBuilder.withTag(name, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String name, Number value) {
            this.spanBuilder.withTag(name, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.spanBuilder.ignoreActiveSpan();
            return this;
        }

        @Override
        public Scope startActive(boolean finishOnClose) {
            return this.spanBuilder.startActive(finishOnClose);
        }

        @Override
        @Deprecated
        public Span startManual() {
            return this.spanBuilder.startManual();
        }
    }

    public static class AgentTracer
    implements Tracer {
        private Tracer tracer;

        public AgentTracer(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public Tracer.SpanBuilder buildSpan(String operation) {
            return new AgentSpanBuilder(this.tracer.buildSpan(operation));
        }

        @Override
        public <C> SpanContext extract(Format<C> format, C carrier) {
            return this.tracer.extract(format, carrier);
        }

        @Override
        public <C> void inject(SpanContext ctx, Format<C> format, C carrier) {
            this.tracer.inject(ctx, format, carrier);
        }

        @Override
        public Span activeSpan() {
            return this.tracer.activeSpan();
        }

        @Override
        public ScopeManager scopeManager() {
            return this.tracer.scopeManager();
        }
    }
}

