/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.internal;

import io.opentelemetry.internal.shaded.jctools.queues.MessagePassingQueue;
import io.opentelemetry.internal.shaded.jctools.queues.MpscArrayQueue;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public final class JcTools {
    public static <T> Queue<T> newFixedSizeQueue(int capacity) {
        try {
            return new MpscArrayQueue(capacity);
        }
        catch (NoClassDefFoundError e) {
            return new ArrayBlockingQueue(capacity);
        }
    }

    public static long capacity(Queue<?> queue) {
        if (queue instanceof MessagePassingQueue) {
            return ((MessagePassingQueue)((Object)queue)).capacity();
        }
        return (long)((ArrayBlockingQueue)queue).remainingCapacity() + (long)queue.size();
    }

    private JcTools() {
    }
}

