/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.AutoValue_MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.DebugUtils;
import io.opentelemetry.sdk.metrics.internal.state.DuplicateMetricStorageException;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.MultiWritableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MeterSharedState {
    private static final Logger logger = Logger.getLogger(MeterSharedState.class.getName());

    public static MeterSharedState create(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        return new AutoValue_MeterSharedState(instrumentationLibraryInfo, new MetricStorageRegistry());
    }

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    abstract MetricStorageRegistry getMetricStorageRegistry();

    public List<MetricData> collectAll(CollectionInfo collectionInfo, MeterProviderSharedState meterProviderSharedState, long epochNanos, boolean suppressSynchronousCollection) {
        Collection<MetricStorage> metrics = this.getMetricStorageRegistry().getMetrics();
        ArrayList<MetricData> result = new ArrayList<MetricData>(metrics.size());
        for (MetricStorage metric : metrics) {
            MetricData current = metric.collectAndReset(collectionInfo, meterProviderSharedState.getResource(), this.getInstrumentationLibraryInfo(), meterProviderSharedState.getStartEpochNanos(), epochNanos, suppressSynchronousCollection);
            if (current == null) continue;
            result.add(current);
        }
        return result;
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState) {
        List<View> views = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo());
        ArrayList<WriteableMetricStorage> storage = new ArrayList<WriteableMetricStorage>(views.size());
        for (View view : views) {
            SynchronousMetricStorage currentStorage = SynchronousMetricStorage.create(view, instrument, meterProviderSharedState.getExemplarFilter());
            if (SynchronousMetricStorage.empty().equals(currentStorage)) continue;
            try {
                storage.add(this.getMetricStorageRegistry().register(currentStorage));
            }
            catch (DuplicateMetricStorageException e) {
                logger.log(Level.WARNING, e, () -> DebugUtils.duplicateMetricErrorMessage(e));
            }
        }
        if (storage.size() == 1) {
            return (WriteableMetricStorage)storage.get(0);
        }
        return new MultiWritableMetricStorage(storage);
    }

    public final void registerLongAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableLongMeasurement> metricUpdater) {
        List<View> views = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo());
        for (View view : views) {
            MetricStorage currentStorage = AsynchronousMetricStorage.longAsynchronousAccumulator(view, instrument, metricUpdater);
            if (AsynchronousMetricStorage.empty().equals(currentStorage)) continue;
            try {
                this.getMetricStorageRegistry().register(currentStorage);
            }
            catch (DuplicateMetricStorageException e) {
                logger.log(Level.WARNING, e, () -> "Failed to register metric.");
            }
        }
    }

    public final void registerDoubleAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        List<View> views = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo());
        for (View view : views) {
            MetricStorage currentStorage = AsynchronousMetricStorage.doubleAsynchronousAccumulator(view, instrument, metricUpdater);
            if (AsynchronousMetricStorage.empty() == currentStorage) continue;
            try {
                this.getMetricStorageRegistry().register(currentStorage);
            }
            catch (DuplicateMetricStorageException e) {
                logger.log(Level.WARNING, e, () -> "Failed to register metric.");
            }
        }
    }
}

