/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.opentelemetry.sdk.metrics.internal.aggregator.AutoValue_MinMaxSumCountAccumulation;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class MinMaxSumCountAccumulation {
    static MinMaxSumCountAccumulation create(long count, double sum, double min, double max) {
        return new AutoValue_MinMaxSumCountAccumulation(count, sum, min, max);
    }

    MinMaxSumCountAccumulation() {
    }

    abstract long getCount();

    abstract double getSum();

    abstract double getMin();

    abstract double getMax();

    final DoubleSummaryPointData toPoint(long startEpochNanos, long epochNanos, Attributes labels) {
        return DoubleSummaryPointData.create(startEpochNanos, epochNanos, labels, this.getCount(), this.getSum(), Arrays.asList(ValueAtPercentile.create(0.0, this.getMin()), ValueAtPercentile.create(100.0, this.getMax())));
    }
}

