/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;

final class WithTraceExemplarFilter
implements ExemplarFilter {
    static final ExemplarFilter INSTANCE = new WithTraceExemplarFilter();

    private WithTraceExemplarFilter() {
    }

    @Override
    public boolean shouldSampleMeasurement(long value, Attributes attributes, Context context) {
        return WithTraceExemplarFilter.hasSampledTrace(context);
    }

    @Override
    public boolean shouldSampleMeasurement(double value, Attributes attributes, Context context) {
        return WithTraceExemplarFilter.hasSampledTrace(context);
    }

    private static boolean hasSampledTrace(Context context) {
        return Span.fromContext((Context)context).getSpanContext().isSampled();
    }
}

