/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.sdk.internal.ScopeConfigurator;
import io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import io.opentelemetry.sdk.logs.internal.AutoValue_LoggerConfig;
import io.opentelemetry.sdk.logs.internal.LoggerConfigBuilder;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class LoggerConfig {
    private static final LoggerConfig DEFAULT_CONFIG = new AutoValue_LoggerConfig(true, Severity.UNDEFINED_SEVERITY_NUMBER, false);
    private static final LoggerConfig DISABLED_CONFIG = new AutoValue_LoggerConfig(false, Severity.UNDEFINED_SEVERITY_NUMBER, false);

    public static LoggerConfig disabled() {
        return DISABLED_CONFIG;
    }

    public static LoggerConfig enabled() {
        return DEFAULT_CONFIG;
    }

    public static LoggerConfigBuilder builder() {
        return new LoggerConfigBuilder();
    }

    public static LoggerConfig defaultConfig() {
        return DEFAULT_CONFIG;
    }

    public static ScopeConfiguratorBuilder<LoggerConfig> configuratorBuilder() {
        return ScopeConfigurator.builder();
    }

    LoggerConfig() {
    }

    static LoggerConfig create(boolean enabled, Severity minimumSeverity, boolean traceBased) {
        return new AutoValue_LoggerConfig(enabled, minimumSeverity, traceBased);
    }

    public abstract boolean isEnabled();

    public abstract Severity getMinimumSeverity();

    public abstract boolean isTraceBased();
}

