/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.AttributesMap;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LoggerSharedState;
import io.opentelemetry.sdk.logs.SdkReadWriteLogRecord;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class SdkLogRecordBuilder
implements LogRecordBuilder {
    protected final LoggerSharedState loggerSharedState;
    protected final LogLimits logLimits;
    protected final InstrumentationScopeInfo instrumentationScopeInfo;
    protected long timestampEpochNanos;
    protected long observedTimestampEpochNanos;
    @Nullable
    protected Context context;
    protected Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    protected String severityText;
    @Nullable
    protected Value<?> body;
    @Nullable
    protected String eventName;
    @Nullable
    private AttributesMap attributes;

    SdkLogRecordBuilder(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.loggerSharedState = loggerSharedState;
        this.logLimits = loggerSharedState.getLogLimits();
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    public SdkLogRecordBuilder setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public SdkLogRecordBuilder setTimestamp(long timestamp, TimeUnit unit) {
        this.timestampEpochNanos = unit.toNanos(timestamp);
        return this;
    }

    public SdkLogRecordBuilder setTimestamp(Instant instant) {
        this.timestampEpochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    public LogRecordBuilder setObservedTimestamp(long timestamp, TimeUnit unit) {
        this.observedTimestampEpochNanos = unit.toNanos(timestamp);
        return this;
    }

    public LogRecordBuilder setObservedTimestamp(Instant instant) {
        this.observedTimestampEpochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    public SdkLogRecordBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    public SdkLogRecordBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public SdkLogRecordBuilder setSeverityText(String severityText) {
        this.severityText = severityText;
        return this;
    }

    public SdkLogRecordBuilder setBody(String body) {
        return this.setBody(Value.of((String)body));
    }

    public SdkLogRecordBuilder setBody(Value<?> value) {
        this.body = value;
        return this;
    }

    public <T> SdkLogRecordBuilder setAttribute(AttributeKey<T> key, @Nullable T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = AttributesMap.create((long)this.logLimits.getMaxNumberOfAttributes(), (int)this.logLimits.getMaxAttributeValueLength());
        }
        this.attributes.put(key, value);
        return this;
    }

    public void emit() {
        if (this.loggerSharedState.hasBeenShutdown()) {
            return;
        }
        Context context = this.context == null ? Context.current() : this.context;
        long observedTimestampEpochNanos = this.observedTimestampEpochNanos == 0L ? this.loggerSharedState.getClock().now() : this.observedTimestampEpochNanos;
        this.loggerSharedState.getLogRecordProcessor().onEmit(context, SdkReadWriteLogRecord.create(this.loggerSharedState.getLogLimits(), this.loggerSharedState.getResource(), this.instrumentationScopeInfo, this.timestampEpochNanos, observedTimestampEpochNanos, Span.fromContext((Context)context).getSpanContext(), this.severity, this.severityText, this.body, this.attributes, this.eventName));
    }
}

