/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.samplers;

import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.internal.TemporaryBuffers;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ImmutableSamplingIntent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class OtelTraceState {
    private static final OtelTraceState EMPTY = new OtelTraceState(-1L, -1L, Collections.emptyList());
    private static final int MAX_OTEL_TRACE_STATE_LENGTH = 256;
    static final int MAX_VALUE_LENGTH = 14;
    static final String OTEL_TRACE_STATE_KEY = "ot";
    private final long randomValue;
    private final long threshold;
    private final List<String> rest;

    static OtelTraceState parse(TraceState traceState) {
        String ot = traceState.get(OTEL_TRACE_STATE_KEY);
        if (ot == null || ot.isEmpty() || ot.length() > 256) {
            return EMPTY;
        }
        long threshold = -1L;
        long randomValue = -1L;
        List<String> rest = Collections.emptyList();
        int idx = 0;
        while (idx < ot.length()) {
            String member;
            int delimIdx = ot.indexOf(59, idx);
            String string = member = delimIdx != -1 ? ot.substring(idx, delimIdx) : ot.substring(idx);
            if (member.startsWith("th:")) {
                threshold = OtelTraceState.parseTh(member.substring("th:".length()));
            } else if (member.startsWith("rv:")) {
                randomValue = OtelTraceState.parseRv(member.substring("rv:".length()));
            } else {
                if (rest.isEmpty()) {
                    rest = new ArrayList<String>();
                }
                rest.add(member);
            }
            if (delimIdx == -1) break;
            idx = delimIdx + 1;
        }
        return new OtelTraceState(randomValue, threshold, rest);
    }

    private static long parseTh(String th) {
        if (th.isEmpty() || th.length() > 14 || !OtelEncodingUtils.isValidBase16String((CharSequence)th)) {
            return -1L;
        }
        if (th.equals("0")) {
            return 0L;
        }
        return OtelEncodingUtils.longFromBase16String((CharSequence)new PaddedValue(th), (int)0);
    }

    private static long parseRv(String rv) {
        if (rv.length() != 14 || !OtelEncodingUtils.isValidBase16String((CharSequence)rv)) {
            return -1L;
        }
        return OtelEncodingUtils.longFromBase16String((CharSequence)new PaddedValue(rv), (int)0);
    }

    static void serializeTh(long threshold, StringBuilder sb) {
        int endIdx;
        if (threshold == 0L) {
            sb.append('0');
            return;
        }
        char[] buf = TemporaryBuffers.chars((int)16);
        OtelEncodingUtils.longToBase16String((long)threshold, (char[])buf, (int)0);
        int startIdx = 2;
        for (endIdx = 16; endIdx > startIdx && buf[endIdx - 1] == '0'; --endIdx) {
        }
        sb.append(buf, startIdx, endIdx - startIdx);
    }

    private static void serializeRv(long randomValue, StringBuilder sb) {
        char[] buf = TemporaryBuffers.chars((int)16);
        OtelEncodingUtils.longToBase16String((long)randomValue, (char[])buf, (int)0);
        int startIdx = 2;
        int endIdx = 16;
        sb.append(buf, startIdx, endIdx - startIdx);
    }

    OtelTraceState(long randomValue, long threshold, List<String> rest) {
        this.randomValue = randomValue;
        this.threshold = threshold;
        this.rest = rest;
    }

    long getRandomValue() {
        return this.randomValue;
    }

    long getThreshold() {
        return this.threshold;
    }

    List<String> getRest() {
        return this.rest;
    }

    String serialize() {
        if (!(ImmutableSamplingIntent.isValidThreshold(this.threshold) && this.threshold != 0x100000000000000L || ImmutableSamplingIntent.isValidRandomValue(this.randomValue) || !this.rest.isEmpty())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (ImmutableSamplingIntent.isValidThreshold(this.threshold) && this.threshold != 0x100000000000000L) {
            sb.append("th:");
            OtelTraceState.serializeTh(this.threshold, sb);
            sb.append(';');
        }
        if (ImmutableSamplingIntent.isValidRandomValue(this.randomValue)) {
            sb.append("rv:");
            OtelTraceState.serializeRv(this.randomValue, sb);
            sb.append(';');
        }
        for (String member : this.rest) {
            sb.append(member);
            sb.append(';');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static class PaddedValue
    implements CharSequence {
        private final String value;

        PaddedValue(String value) {
            this.value = value;
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        public char charAt(int index) {
            if (index < 2) {
                return '0';
            }
            if ((index -= 2) < this.value.length()) {
                return this.value.charAt(index);
            }
            return '0';
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }
}

