/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableAlwaysOffSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableAlwaysOnSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableParentThresholdSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableTraceIdRatioBasedSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;

public interface ComposableSampler {
    public static ComposableSampler alwaysOff() {
        return ComposableAlwaysOffSampler.INSTANCE;
    }

    public static ComposableSampler alwaysOn() {
        return ComposableAlwaysOnSampler.INSTANCE;
    }

    public static ComposableSampler traceIdRatioBased(double ratio) {
        return new ComposableTraceIdRatioBasedSampler(ratio);
    }

    public static ComposableSampler parentThreshold(ComposableSampler rootSampler) {
        return new ComposableParentThresholdSampler(rootSampler);
    }

    public SamplingIntent getSamplingIntent(Context var1, String var2, String var3, SpanKind var4, Attributes var5, List<LinkData> var6);

    public String getDescription();
}

