/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ComposableSampler;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.ImmutableSamplingIntent;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.OtelTraceState;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.function.Function;

final class ComposableParentThresholdSampler
implements ComposableSampler {
    private final ComposableSampler rootSampler;
    private final String description;

    ComposableParentThresholdSampler(ComposableSampler rootSampler) {
        this.rootSampler = rootSampler;
        this.description = "ComposableParentThresholdSampler{rootSampler=" + rootSampler + "}";
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SpanContext parentSpanContext = Span.fromContext((Context)parentContext).getSpanContext();
        if (!parentSpanContext.isValid()) {
            return this.rootSampler.getSamplingIntent(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        OtelTraceState otTraceState = OtelTraceState.parse(parentSpanContext.getTraceState());
        if (ImmutableSamplingIntent.isValidThreshold(otTraceState.getThreshold())) {
            return ImmutableSamplingIntent.create(otTraceState.getThreshold(), true, Attributes.empty(), Function.identity());
        }
        long threshold = parentSpanContext.getTraceFlags().isSampled() ? 0L : -1L;
        return ImmutableSamplingIntent.create(threshold, false, Attributes.empty(), Function.identity());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }
}

