/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class DeclarativeConfigContext {
    private final SpiHelper spiHelper;
    private final List<Closeable> closeables = new ArrayList<Closeable>();
    @Nullable
    private volatile MeterProvider meterProvider;
    @Nullable
    private Resource resource = null;

    DeclarativeConfigContext(SpiHelper spiHelper) {
        this.spiHelper = spiHelper;
    }

    static DeclarativeConfigContext create(ComponentLoader componentLoader) {
        return new DeclarativeConfigContext(SpiHelper.create((ComponentLoader)componentLoader));
    }

    <T extends Closeable> T addCloseable(T closeable) {
        this.closeables.add(closeable);
        return closeable;
    }

    List<Closeable> getCloseables() {
        return Collections.unmodifiableList(this.closeables);
    }

    @Nullable
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public void setMeterProvider(MeterProvider meterProvider) {
        this.meterProvider = meterProvider;
    }

    Resource getResource() {
        if (this.resource == null) {
            throw new DeclarativeConfigException("Resource has not been configured yet.");
        }
        return this.resource;
    }

    void setResource(Resource resource) {
        this.resource = resource;
    }

    SpiHelper getSpiHelper() {
        return this.spiHelper;
    }

    <T> T loadComponent(Class<T> type, String name, Object model) {
        DeclarativeConfigProperties config = DeclarativeConfiguration.toConfigProperties(model, this.spiHelper.getComponentLoader());
        List componentProviders = this.spiHelper.load(ComponentProvider.class);
        List matchedProviders = componentProviders.stream().map(componentProvider -> componentProvider).filter(componentProvider -> componentProvider.getType() == type && name.equals(componentProvider.getName())).collect(Collectors.toList());
        if (matchedProviders.isEmpty()) {
            throw new DeclarativeConfigException("No component provider detected for " + type.getName() + " with name \"" + name + "\".");
        }
        if (matchedProviders.size() > 1) {
            throw new DeclarativeConfigException("Component provider conflict. Multiple providers detected for " + type.getName() + " with name \"" + name + "\": " + componentProviders.stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(",", "[", "]")));
        }
        ComponentProvider provider2 = (ComponentProvider)matchedProviders.get(0);
        try {
            return (T)provider2.create(config);
        }
        catch (Throwable throwable) {
            throw new DeclarativeConfigException("Error configuring " + type.getName() + " with name \"" + name + "\"", throwable);
        }
    }
}

