/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.aws.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.extension.aws.resource.SimpleHttpClient;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Deprecated
public final class EcsResource {
    private static final Logger logger = Logger.getLogger(EcsResource.class.getName());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String ECS_METADATA_KEY_V4 = "ECS_CONTAINER_METADATA_URI_V4";
    private static final String ECS_METADATA_KEY_V3 = "ECS_CONTAINER_METADATA_URI";
    private static final Resource INSTANCE = EcsResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    private static Resource buildResource() {
        return EcsResource.buildResource(System.getenv(), new SimpleHttpClient());
    }

    static Resource buildResource(Map<String, String> sysEnv, SimpleHttpClient httpClient) {
        String ecsMetadataUrl = sysEnv.getOrDefault(ECS_METADATA_KEY_V4, sysEnv.getOrDefault(ECS_METADATA_KEY_V3, ""));
        if (!ecsMetadataUrl.isEmpty()) {
            AttributesBuilder attrBuilders = Attributes.builder();
            EcsResource.fetchMetadata(httpClient, ecsMetadataUrl, attrBuilders);
            EcsResource.fetchMetadata(httpClient, ecsMetadataUrl + "/task", attrBuilders);
            return Resource.create((Attributes)attrBuilders.build(), (String)"https://opentelemetry.io/schemas/1.13.0");
        }
        return Resource.empty();
    }

    static void fetchMetadata(SimpleHttpClient httpClient, String url, AttributesBuilder attrBuilders) {
        String json = httpClient.fetchString("GET", url, Collections.emptyMap(), null);
        if (json.isEmpty()) {
            return;
        }
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)"aws");
        attrBuilders.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"aws_ecs");
        try (JsonParser parser = JSON_FACTORY.createParser(json);){
            parser.nextToken();
            LogArnBuilder logArnBuilder = new LogArnBuilder();
            EcsResource.parseResponse(parser, attrBuilders, logArnBuilder);
            logArnBuilder.getLogGroupArn().ifPresent(logGroupArn -> attrBuilders.put(ResourceAttributes.AWS_LOG_GROUP_ARNS, Collections.singletonList(logGroupArn)));
            logArnBuilder.getLogStreamArn().ifPresent(logStreamArn -> attrBuilders.put(ResourceAttributes.AWS_LOG_STREAM_ARNS, Collections.singletonList(logStreamArn)));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Can't get ECS metadata", e);
        }
    }

    static void parseResponse(JsonParser parser, AttributesBuilder attrBuilders, LogArnBuilder logArnBuilder) throws IOException {
        if (!parser.isExpectedStartObjectToken()) {
            logger.log(Level.WARNING, "Couldn't parse ECS metadata, invalid JSON");
            return;
        }
        block30: while (parser.nextToken() != JsonToken.END_OBJECT) {
            String value = parser.nextTextValue();
            switch (parser.getCurrentName()) {
                case "DockerId": {
                    attrBuilders.put(ResourceAttributes.CONTAINER_ID, (Object)value);
                    continue block30;
                }
                case "DockerName": {
                    attrBuilders.put(ResourceAttributes.CONTAINER_NAME, (Object)value);
                    continue block30;
                }
                case "ContainerARN": {
                    attrBuilders.put(ResourceAttributes.AWS_ECS_CONTAINER_ARN, (Object)value);
                    logArnBuilder.setContainerArn(value);
                    continue block30;
                }
                case "Image": {
                    DockerImage parsedImage = DockerImage.parse(value);
                    if (parsedImage == null) continue block30;
                    attrBuilders.put(ResourceAttributes.CONTAINER_IMAGE_NAME, (Object)parsedImage.getRepository());
                    attrBuilders.put(ResourceAttributes.CONTAINER_IMAGE_TAG, (Object)parsedImage.getTag());
                    continue block30;
                }
                case "ImageID": {
                    attrBuilders.put("aws.ecs.container.image.id", value);
                    continue block30;
                }
                case "LogOptions": {
                    EcsResource.parseResponse(parser, attrBuilders, logArnBuilder);
                    continue block30;
                }
                case "awslogs-group": {
                    attrBuilders.put(ResourceAttributes.AWS_LOG_GROUP_NAMES, (Object[])new String[]{value});
                    logArnBuilder.setLogGroupName(value);
                    continue block30;
                }
                case "awslogs-stream": {
                    attrBuilders.put(ResourceAttributes.AWS_LOG_STREAM_NAMES, (Object[])new String[]{value});
                    logArnBuilder.setLogStreamName(value);
                    continue block30;
                }
                case "awslogs-region": {
                    logArnBuilder.setRegion(value);
                    continue block30;
                }
                case "TaskARN": {
                    attrBuilders.put(ResourceAttributes.AWS_ECS_TASK_ARN, (Object)value);
                    continue block30;
                }
                case "LaunchType": {
                    attrBuilders.put(ResourceAttributes.AWS_ECS_LAUNCHTYPE, (Object)value.toLowerCase());
                    continue block30;
                }
                case "Family": {
                    attrBuilders.put(ResourceAttributes.AWS_ECS_TASK_FAMILY, (Object)value);
                    continue block30;
                }
                case "Revision": {
                    attrBuilders.put(ResourceAttributes.AWS_ECS_TASK_REVISION, (Object)value);
                    continue block30;
                }
            }
            parser.skipChildren();
        }
    }

    private EcsResource() {
    }

    private static class LogArnBuilder {
        @Nullable
        String region;
        @Nullable
        String account;
        @Nullable
        String logGroupName;
        @Nullable
        String logStreamName;

        private LogArnBuilder() {
        }

        void setRegion(@Nullable String region) {
            this.region = region;
        }

        void setLogGroupName(@Nullable String logGroupName) {
            this.logGroupName = logGroupName;
        }

        void setLogStreamName(@Nullable String logStreamName) {
            this.logStreamName = logStreamName;
        }

        void setContainerArn(@Nullable String containerArn) {
            if (containerArn != null) {
                this.account = containerArn.split(":")[4];
            }
        }

        Optional<String> getLogGroupArn() {
            if (this.region == null || this.account == null || this.logGroupName == null) {
                return Optional.empty();
            }
            return Optional.of("arn:aws:logs:" + this.region + ":" + this.account + ":log-group:" + this.logGroupName);
        }

        Optional<String> getLogStreamArn() {
            if (this.region == null || this.account == null || this.logGroupName == null || this.logStreamName == null) {
                return Optional.empty();
            }
            return Optional.of("arn:aws:logs:" + this.region + ":" + this.account + ":log-group:" + this.logGroupName + ":log-stream:" + this.logStreamName);
        }
    }

    private static class DockerImage {
        private static final Pattern imagePattern = Pattern.compile("^(?<repository>([^/\\s]+/)?([^:\\s]+))(:(?<tag>[^@\\s]+))?(@sha256:(?<sha256>\\d+))?$");
        final String repository;
        final String tag;

        private DockerImage(String repository, String tag) {
            this.repository = repository;
            this.tag = tag;
        }

        String getRepository() {
            return this.repository;
        }

        String getTag() {
            return this.tag;
        }

        @Nullable
        static DockerImage parse(@Nullable String image) {
            if (image == null || image.isEmpty()) {
                return null;
            }
            Matcher matcher = imagePattern.matcher(image);
            if (!matcher.matches()) {
                logger.log(Level.WARNING, "Couldn't parse image '" + image + "'");
                return null;
            }
            String repository = matcher.group("repository");
            String tag = matcher.group("tag");
            if (tag == null || tag.isEmpty()) {
                tag = "latest";
            }
            return new DockerImage(repository, tag);
        }
    }
}

